/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.mime.LegacyString;
import cryptix.security.CryptoError;
import cryptix.security.MessageHash;

public abstract class MessageDigest {
    private java.security.MessageDigest md;

    protected MessageDigest(java.security.MessageDigest messageDigest) {
        this.md = messageDigest;
    }

    public final int hash_length() {
        try {
            java.security.MessageDigest messageDigest = (java.security.MessageDigest)this.md.getClass().newInstance();
            return messageDigest.digest().length;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        throw new CryptoError(String.valueOf(this.md.getAlgorithm()) + ": hash_length() failed");
    }

    public final int length() {
        return this.hash_length();
    }

    public final String name() {
        return this.md.getAlgorithm();
    }

    public final MessageHash digestAsHash() {
        return MessageHash.fromDigest(this);
    }

    public final void add(String string, int n, int n2) {
        this.md.update(LegacyString.toByteArray(string, n, n2));
    }

    public final void add(String string) {
        this.md.update(LegacyString.toByteArray(string));
    }

    public final void add(byte[] byArray) {
        this.md.update(byArray);
    }

    public final void add(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    public final byte[] digest(byte[] byArray) {
        return this.md.digest(byArray);
    }

    public final byte[] digest() {
        return this.md.digest();
    }

    public final void reset() {
        this.md.reset();
    }

    public static byte[] hash(String string, MessageDigest messageDigest) {
        return messageDigest.digest(LegacyString.toByteArray(string));
    }

    public static byte[] hash(byte[] byArray, MessageDigest messageDigest) {
        return messageDigest.digest(byArray);
    }
}

