/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.md.SHA1;
import cryptix.test.BaseTest;
import cryptix.util.core.Hex;
import java.security.MessageDigest;

class TestSHA1
extends BaseTest {
    private static String[][] testData1 = new String[][]{{"", "da39a3ee5e6b4b0d3255bfef95601890afd80709"}, {"1", "356a192b7913b04c54574d18c28d46e6395428ab"}, {"abc", "A9993E364706816ABA3E25717850C26C9CD0D89D"}, {"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "84983E441C3BD26EBAAE4AA1F95129E5E54670F1"}, {"Anyone got any SHA-1 test data?", "09b9e9c04a84ce274942048acf3a6f2ff4a8a39c"}, {"Of cabbages and kings", "5f093d74a9cb1f2f14537bcf3a8a1ffd59b038a2"}};

    public static void main(String[] stringArray) {
        new TestSHA1().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        int n = 0;
        int n2 = 0;
        String[][] stringArray = testData1;
        SHA1 sHA1 = new SHA1();
        this.setExpectedPasses(stringArray.length + 1);
        int n3 = 0;
        while (n3 < stringArray.length) {
            ((MessageDigest)((Object)sHA1)).reset();
            byte[] byArray = ((MessageDigest)((Object)sHA1)).digest(stringArray[n3][0].getBytes());
            String string = Hex.toString((byte[])byArray);
            this.out.println("         data: '" + stringArray[n3][0] + "'");
            this.out.println("  computed md: " + string);
            this.out.println(" certified md: " + stringArray[n3][1]);
            boolean bl = string.equalsIgnoreCase(stringArray[n3][1]);
            this.passIf(bl, "Data Set #" + (n3 + 1));
            if (bl) {
                this.out.println("   * Hash (#" + ++n + "/" + (n3 + 1) + ") good");
            } else {
                this.out.println("===> Hash (#" + ++n2 + "/" + (n3 + 1) + ") FAILED  <===");
                this.out.println("     (no debugging available)");
            }
            this.out.println("");
            ++n3;
        }
        System.out.println("\nSHA1 succeeded (" + n3 + " tests)");
        SHA1.self_test();
        this.passIf(true, "Self Test (no diags)");
    }

    TestSHA1() {
    }
}

