#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <osfcn.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>

#include "arun.h"


#define PAGE 2048

void amiga_init(void)
{
    int fd = open("/dev/zero", O_RDWR);
    if (fd < 0 ||
	mmap((caddr_t)0,
	     PAGE,
	     PROT_READ|PROT_WRITE, MAP_PRIVATE|MAP_FIXED,
	     fd, 0))
	panic("can't map page zero: %s", strerror(errno));
    (void)close(fd);
    *(void **)4 = exec_init();
    (void)mprotect((caddr_t)0, PAGE, PROT_READ);
    dos_init();
}
