#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Window (term)


************************************************************
*                                                          *
*  Subroutine  Window_Option                               *
*                                                          *
*     This subroutine is used to ask the user to enter     *
*     the window in world coordinates.  A minor amount     *
*     of error checking is performed to make sure the      *
*     user enters the coordinates in increasing order.     *
*                                                          *
************************************************************


        Real          Xmax, Xmin, Ymax, Ymin
        Common /data/ Xmax, Xmin, Ymax, Ymin
        Save   /data/

        Character *10   hix, hiy, lowx, lowy
        Common /winlbl/ hix, hiy, lowx, lowy
        Save   /winlbl/

        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Character    dummy, ans
        Character*10 num0, num1, num2, num3, num4
        Character*30 nmbr
        Real         temp
        Integer      term

    1   Call clear(term)
        Call number (WXmin, .FALSE., num0)
        Call number (WXmin, .TRUE., num1)
        Call number (WXmax, .TRUE., num2)
        Call number (WYmin, .TRUE., num3)
        Call number (WYmax, .TRUE., num4)
*
*     (* If labels have been changed, give user a chance to set them
*        back to normal values. *)
*
        IF (num0 .NE. lowx .OR. num2 .NE. hix .OR.
     +      num3 .NE. lowy .OR. num4 .NE. hiy) THEN
          Write (*,5)
    5     Format (/,5x,'Would you like window labels set back to ',
     +          'their standard',/5x,'numerical values?   (Y,N)')
          Read (*,'(a1)',err=1) ans
          IF (ans .EQ. 'Y' .OR. ans .EQ. 'y') THEN
            Call number (WXmin, .FALSE., lowx)
            Call number (WXmax, .TRUE., hix)
            Call number (WYmin, .TRUE., lowy)
            Call number (WYmax, .TRUE., hiy)
          ENDIF
          Call clear(term)
        ENDIF
*
        Write (*,10) num1, num2, lowx, hix, num3, num4, lowy, hiy
   10   Format (/,15x,'Specify Window',///
     +          ,5x,'Current window settings:',//
     +          ,12x,'X-min',10x,'X-max',/,10x,10('-'),5x,10('-')/
     +          ,10x,a10,5x,a10,/,9x,'<',a10,'>',3x,'<',a10,'>'//
     +          ,12x,'Y-min',10x,'Y-max',/,10x,10('-'),5x,10('-'),/10x
     +          ,a10,5x,a10,/,9x,'<',a10,'>',3x,'<',a10,'>',/5x,/
     +          ,'Press <return> to keep current'
     +          ,' value!',/)
        Write (*,20)
   20   Format(/,5x,'Please enter the new window X-minimum ...')
        Read (*,'(a30)',err=1) nmbr
        IF (nmbr .NE. ' ') THEN
          Read (nmbr,17,err=1) WXmin
          Call number (WXmin, .TRUE., num1)
          Call number (WXmin, .FALSE., lowx)
        ENDIF
   17   format(f11.0)

    2   Call clear(term)
        Write (*,10) num1, num2, lowx, hix, num3, num4, lowy, hiy
        Write (*,30)
   30   Format(/,5x,'Please enter the new window X-maximum ...')
        Read (*,'(a30)',err=2) nmbr
        IF (nmbr .NE. ' ') THEN
          Read (nmbr,17,err=2) WXmax
          Call number (WXmax, .TRUE., num2)
          Call number (WXmax, .TRUE., hix)
        ENDIF

*       (* If max is larger than min, swap them *)
        IF ((WXmax - WXmin) .LT. 0) THEN
          temp = WXmin
          WXmin = WXmax
          WXmax = temp
          Call number (WXmin, .TRUE., num1)
          Call number (WXmin, .FALSE., lowx)
          Call number (WXmax, .TRUE., num2)
          Call number (WXmax, .TRUE., hix)
        ELSE IF ((WXmax - WXmin) .EQ. 0) THEN
          Write (*,40) 
   40     Format(/,5x,'Maximum and minimum X values are the same!!',/
     +            ,5x,'Reseting to maximum and minimum X data points.')
          Read (*,'(a1)') 
          WXmax = Xmax
          WXmin = Xmin
          Call number (WXmin, .TRUE., num1)
          Call number (WXmin, .FALSE., lowx)
          Call number (WXmax, .TRUE., num2)
          Call number (WXmax, .TRUE., hix)
        ENDIF

 
*       (* Get the Y min and max points for the window. *)
    3   Call clear(term)
        Write (*,10) num1, num2, lowx, hix, num3, num4, lowy, hiy
        Write (*,50)
   50   Format(/,5x,'Please enter the new window Y-min ...')
        Read (*,'(a30)',err=3) nmbr
        IF (nmbr .NE. ' ') THEN
          Read (nmbr,17,err=3) WYmin
          Call number (WYmin, .TRUE., num3)
          Call number (WYmin, .TRUE., lowy)
        ENDIF

    4   Call clear(term)
        Write (*,10) num1, num2, lowx, hix, num3, num4, lowy, hiy
        Write (*,60)
   60   Format(/,5x,'Please enter the new window Y-max ...')
        Read (*,'(a30)',err=4) nmbr
        IF (nmbr .NE. ' ') THEN
          Read (nmbr,17,err=4) WYmax
          Call number (WYmax, .TRUE., num4)
          Call number (WYmax, .TRUE., hiy)
        ENDIF

*       (* If max is larger than min, swap them *)
        IF ((WYmax - WYmin) .LT. 0) THEN
          temp = WYmin
          WYmin = WYmax
          WYmax = temp
          Call number (WYmin, .TRUE., num3)
          Call number (WYmax, .TRUE., num4)
          Call number (WYmin, .TRUE., lowy)
          Call number (WYmax, .TRUE., hiy)
        ELSE IF ((WYmax - WYmin) .EQ. 0) THEN
          Write (*,70)
   70     Format(/,5x,'Maximum and minimum Y values are the same!!',/
     +            ,5x,'Reseting to maximum and minimum Y data points.')
          Read (*,'(a1)') dummy
          WYmax = Ymax
          WYmin = Ymin
          Call number (WYmin, .TRUE., num3)
          Call number (WYmax, .TRUE., num4)
          Call number (WYmin, .TRUE., lowy)
          Call number (WYmax, .TRUE., hiy)
        ENDIF

        RETURN
        END
