#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine VTRegD(XC, YC, NC, NumCrv, Crvtyp, NumTic, term,
     +                     shadng)


*****************************************************************
*                                                               *
*  Subroutine Device_VT240_Regis                                *
*                                                               *
*     Subroutine vt240gD is a device dependent routine, used    *
*     to plot the object stored in 'XC' & 'YC' with NC          *
*     points. The arrays are stored in normalized device        *
*     coordinates, the points are converted into GIGI de-       *
*     vice, and then position (P) and vector (V) commands       *
*     are used to draw the line.                                *
*                                                               *
*     The clipped curve is stored in arrays 'XC', 'YC',         *
*     with 'NC' points.  If a continuous plot is desired        *
*     the object is stored as a series of lines segments        *
*     else, if a point plot is desired the object is            *
*     stored as a series of points.                             *
*                                                               *
*****************************************************************


        Integer    cont, point, discrt, bar, marker
        Parameter (cont = 1, point = 2, discrt = 3, bar = 4, marker = 5)

        Character *7    crv(3)
        Common /Crvlbl/ crv
        Save   /Crvlbl/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Integer        CColor(3), Backgd
        Common /CDefs/ CColor, Backgd
        Save   /CDefs/

        Integer        CType(3)
        Common /lntyp/ CType
        Save   /lntyp/

        Real     XC(maxC,num), YC(maxC,num), golden
        Integer  NumCrv, NC(NumCrv), CrvTyp(3), NumTic(2), term
        Integer  TXmax, TXmin, DXmax, DXmin, DYmax, DYmin, legend, 
     +           Gx, Gy, I, J
        Logical  shadng

        Character  PntTyp(5)
        Integer    hue(0:7), light(0:7), sat(0:7)
        Integer    typln(5)
        Data       PntTyp /'*','+','0','x','o'/
        Data       hue, light, sat /0,0,120,60,240,300,180,0,
     +                              0,50,50,50,50,50,50,99,
     +                              0,100,100,100,100,100,100,0/
        Data       typln /1,4,3,8,9/

        Call clear(term)

*       (* Puts the terminal into graphics mode. *)
        Write (*,10) Char(27)
   10   Format (a1,'Pp')

*       (* Reset the VT240 to standard defaults. *)
        Write (*,5) hue(Backgd), light(Backgd), sat(Backgd)
   5    Format ('T(VD0,S1,D0) W(V I3 P1) S(M0(AH',i3,'L',i3,'S',
     +          i3,')) ','S(C1)')
        DO 50 I = 1,3
          Write (*,25) I, hue(CColor(I)), light(CColor(I)), 
     +                 sat(CColor(I))
  25      Format ('S(M',I1,'(AH',i3,'L',i3,'S',i3,'))')
  50    CONTINUE

        golden = (sqrt(5.0) + 1.0)/2.0
        DYmin = 50
        DYmax = 400
        DXmin = 150
        DXmax = (DYmax - DYmin)*golden + DXmin
        legend = 110

        Call GigiBx(term, NumTic, DXmax, DXmin, DYmax, DYmin)

        DO 100 J = 1, NumCrv

*         (* Set the plot color. *)
          Write (*,15) J, typln(CType(J))
   15     Format ('W(I',I1,'P',I1,')')
          IF (shadng) THEN
            Write (*,18) DYmax
   18       Format ('W(S[,',i3,'])')
          ENDIF

*         (* Check to see what type of plot is desired. *)


          IF (CrvTyp(j) .EQ. discrt) THEN

*           (* Then convert, position, and vector the line segments. *)
            DO 400 I = 1, NC(J)
*             (* Position the point to the bottom of the x-axis. *)
              Gx = XC(I,J)*(DXmax - DXmin) +DXmin
              Gy = DYmax
              Write (*,20) Gx, Gy

*             (* Vector to the top of the 'y' position. *)
              Gy = (DYmin - DYmax)*YC(I,J) +DYmax
              Write (*,30) Gx, Gy 
  400       CONTINUE

          ELSE IF (CrvTyp(j) .EQ. bar) THEN

*             (* Position the point on the x-axis. *)
              Gx = XC(1,J)*(DXmax - DXmin) +DXmin
              Gy = DYmax
              Write (*,20) Gx, Gy

              TXmax = XC(1,J)
              TXmin = XC(1,J)

*           (* Then convert, position, and vector the line segments. *)
            DO 500 I = 1, NC(J) -1

              IF (TXmax .LT. XC(I,J)) TXmax = XC(I,J)
              IF (TXmin .GT. XC(I,J)) TXmin = XC(I,J)

*             (* Vector to the top of the 'y' position. *)
              Gy = (DYmin - DYmax)*YC(I,J) +DYmax
              Write (*,30) Gx, Gy 
*             (* Vector to the next 'x' position. *)
              Gx = XC(I+1,J)*(DXmax - DXmin) +DXmin
              Write (*,30) Gx, Gy 
*             (* Vector back down to the x-axis. *) 
              Gy = DYmax
              Write (*,30) Gx, Gy
  500       CONTINUE
*           (* Repeat the process for the last point. *)
              Gy = (DYmin - DYmax)*YC(NC(J),J) +DYmax
            Write (*,30) Gx, Gy

            IF ((Gx +(TXmax - TXmin)/NC(J)) .LT. DXmax) THEN
              Gx = Gx + (TXmax - TXmin)/NC(J)
            ELSE
              Gx = DXmax
            ENDIF

            Write (*,30) Gx, Gy
            Write (*,30) Gx, DYmax
          ELSE
            IF (CrvTyp(j) .EQ. cont .OR. CrvTyp(j) .EQ. marker) THEN
*             (* Then convert, position, and vector the line segments. *)
              DO 200 I = 1, NC(J), 2
*               (* Position the first point. *)
                Gx = XC(I,J)*(DXmax - DXmin) +DXmin
                Gy = (DYmin - DYmax)*YC(I,J) +DYmax
                Write (*,20) Gx, Gy
   20           Format ('P[',i3,',',i3,']')

*               (* Vector to the second point. *)
                Gx = XC(I+1,J)*(DXmax - DXmin) +DXmin
                Gy = (DYmin - DYmax)*YC(I+1,J) +DYmax
                Write (*,30) Gx, Gy 
   30           Format ('V[',i3,',',i3,']')
  200         CONTINUE
            ENDIF

            IF (CrvTyp(j) .EQ. point .OR. CrvTyp(j) .EQ. marker) THEN
*             (* Then position the point, and mark it. *)
              DO 300 I = 1, NC(J)
*               (* Position the point. *)
                Gx = XC(I,J)*(DXmax - DXmin) +DXmin -5
                Gy = (DYmin - DYmax)*YC(I,J) +DYmax -8
                Write (*,40) Gx, Gy, PntTyp(J)
   40           Format ('P[',i3,',',i3,']  T(S1)''',a1,'''')
  300         CONTINUE
            ENDIF
          ENDIF


          IF (CrvTyp(j) .EQ. point .OR. CrvTyp(j) .EQ. marker) THEN
            Write (*,140) legend, crv(j), (PntTyp(J),I=1,5)
  140       Format ('W(S0)  P[',i3,',455] T(S1)''',a7,' ',
     +              5(' ',a1),'''')
          ENDIF

          IF (CrvTyp(j) .NE. point) THEN
            Write (*,150) legend, crv(j)
  150       Format ('W(S0)  P[',i3,',455] T(S1)''',a7,' '''
     +              'P[+4,+7] V[+95]')
          ENDIF
          legend = legend +200

  100   CONTINUE

*       (* Wait til the user hits return, then return to 'menu'. *)
        Write (*,60)
   60   Format('P[0,0] S(C0)')
        Read (*,'(a1)') 

*       (* Takes the terminal out of graphic mode. *)
        Write (*,70) Char(27), Char(92), Char(27)
   70   Format ('S(M2(AH100L100S0)) S(M0(AH0L0S120))',3a1,'[!p')

        RETURN
        END
