		/*  xyps - converts xylang into postscript */

#include <stdio.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include "patch.h"

#define YES	(1)
#define NO	(0)

#define MAXL	500	/* how many lineto before a stroke */
#define SCALE   0.123   /* scale factor in the post.ps prolog */
#define TX 	40.0	/* x translate in the post.ps prolog */
#define TY 	120.0	/* y translate in the post.ps prolog */
#if 0
#define LX	92.0	/* x space for y label */
#define LY	61.0	/* y space for x label */
#else
#define LX  0       /* let xyplot compute space needed for x,y labels */
#define LY  0
#endif

typedef struct { int llx,lly,urx,ury; } BBOX;

int printtimeQ = YES,
    printproQ = YES,
    optionproQ = NO,
    otherfontQ = NO,
    landscapeQ = NO,
    printheaderQ = NO,
    forceepsQ=YES,
    conformingQ = YES,
    erasures;

char *hstring,
     *font,
     *ProgName,
     *proname;

FILE *infile;


main(ac,av)
int ac;
char *av[];
{
	char *in,text[256],ftext[512],gstr[30],*date;
	char *getenv(),*nextline();
	int i,x,y,x1,x2,y1,y2,c;
	int nl,pmode,stroked,clearpage,pagenumber;
	int encapsulatedQ;
	float size;
	FILE *prolog, *fopen();
	BBOX bbox;

	ProgName = av[0];
	infile=stdin;
	pagenumber = 0;
	if (ac!=1) readopts(ac,av);

	/* read the input and set flags for eps */
	getxyin(infile,&bbox);

	conformingQ = conformingQ && forceepsQ ;
	encapsulatedQ = conformingQ && (erasures == 1);
	/* print header junk */
	if (conformingQ) {
		if (encapsulatedQ)
			printf("%%!PS-Adobe-2.0 EPSF-2.0\n");
		else 
			printf("%%!PS-Adobe-2.0\n");
		printf("%%%%BoundingBox: ");
		printf("%-6d %-6d %-6d %-6d\n",
				 bbox.llx,bbox.lly,bbox.urx,bbox.ury);
		printf("%%%%Title: stdin\n");
		printf("%%%%Creator: %s\n",av[0]);
		maketimestr(&date);
		printf("%%%%CreationDate: %s\n",date);
		/* the next two have to be fixed */
		printf("%%%%DocumentFonts: Helvetica Symbol Courier\n");
		printf("%%%%DocumentProcSets: post 1.0 1\n");
		printf("%%%%EndComents\n");
	}

	/* print the prolog */
	if (printproQ) {
	    /* find out where to get the prolog from */
		/* first, command line:         -p proname
		 * then, environment:           setenv XYPRO proname
		 * then, current directory:     xypost
		 * finally, hard-coded default: LIBPRO
		 * and if there are any errors, bail out   
		 */

	    if (optionproQ) {
			prolog = fopen(proname,"r");
		} else if ( (proname=getenv("XYPRO")) != NULL) {
			prolog = fopen(proname,"r");
		} else if ( (prolog=fopen("xypost","r")) != NULL ) {
			proname = strdup("xypost");
		} else {
			proname = strdup(LIBPRO);
			prolog = fopen(LIBPRO,"r");
		}
		
	    if(prolog==NULL) {
			fprintf(stderr,
					"%s: Prolog file \"%s\" not found.\nDefaults:\n",
					av[0],proname);
			fprintf(stderr,
					"  1) command line:           -p proname\n");
			fprintf(stderr,
					"  2) environment:            setenv XYPRO proname\n");
			fprintf(stderr,
					"  3) in current directory:   ./%s\n","xypost");
			fprintf(stderr,
					"  4) in hardcoded directory: %s\n",LIBPRO);
			exit(-1);
	    }

	    if(conformingQ) 
			printf("%%%%BeginProcSet: post 1.0 1\n");
	    /* copy it out */
	    while( (c=getc(prolog)) != EOF ) putc(c,stdout);
	    fclose(prolog);
	    if(conformingQ) 
			printf("%%%%EndProcSet\n");
	}
	if (conformingQ) {
		printf("%%%%EndProlog\n\n");
	}


	/* x and y have the current point inside the loop */
	i=0;pmode =NO; nl=0;stroked=NO;clearpage=YES;
	while((in=nextline())!=NULL) {	
		if (in[0] != 'p') pmode = NO;
		if(nl>=MAXL) {
			printf("%% A lot of lineto so lets \nstroke \n");
			printf("%6d %6d m\n",x,y);
			nl=0;stroked=YES;
		}
		if (clearpage) {
			++pagenumber;
			printf("%%%%Page: %d %d\n",pagenumber,pagenumber);
			if (landscapeQ) 
				printf("xydict begin\nlandstartup\n");
			else 
				printf("xydict begin\nstartup\n");
			if (printheaderQ) printheader();
			if (printtimeQ) printtime();
			if(otherfontQ) setotherfont();
			clearpage = NO;
		}

		switch (in[0]) {
		   case 'm' : 	sscanf(in,"%*s %d %d",&x,&y);
				printf("%6d %6d m\n",x,y);
				break;
		   case 'p' : 	sscanf(in,"%*s %d %d",&x,&y);
				if (!pmode) {
				   pmode = YES;
				   printf("spm\n");
			  	   printf("%6d %6d p\n",x,y);
				} else {
			  	   printf("%6d %6d p\n",x,y);
				}
				break;
		   case 'l' :	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				printf("%6d %6d %6d %6d l\n", x1,y1,x2,y2);
				++nl; stroked=NO;
				x=x1;y=y1;
				break;
		   case 'n' : 	sscanf(in,"%*s %d %d",&x,&y);
				printf("%6d %6d n\n",x,y);
				++nl; stroked=NO;
				break;
		   case 's' : 	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				break;
		   case 'b' : 	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				printf("%%%%BoundingBox: ");
				printf("%8.0f %8.0f %8.0f %8.0f\n",
				      x1*SCALE+TX,
				      y1*SCALE+TY,
				      x2*SCALE+TX,
				      y2*SCALE+TY
				);
				break;
		   case 't' :	sscanf(in,"%*s %s",text); 
				parse(ftext,text);
				printf("%s 1.0 %6d %6d t\n",ftext,x,y);
				break;
		   case 'f' :	sscanf(in,"%*s %s",text);
				nl=0;
				printf("stroke %s\n",text);
				stroked=YES;
				break;
		   case 'e' :	printf("e\n");
				printf("end %% the xydict\n");
				printf("%%%%PageTrailer\n\n");
				clearpage=YES;
				break;
		   case 'a' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				if (size>0)
					printf("%s %.3f %6d %6d a\n",ftext,size,x,y);
				break;
		   case 'r' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				isreal(text);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				if (size>0)
					printf("%s %.3f %6d %6d r\n",ftext,size,x,y);
				break;
		   case 'i' :   sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				isreal(text);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				if (size>0)
					printf("%s %.3f %6d %6d c\n",ftext,size,x,y);
				break;
		   case 'c' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				isreal(text);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				if (size>0)
					printf("%s %.3f %6d %6d c\n",ftext,size,x,y);
				break;
		   case 'v' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				parse(ftext,text);
				if (size>0)
					printf("%s %.3f %6d %6d v\n",ftext,size,x,y);
				break;
		   case 'w' :   sscanf(in,"%*s %f",&size);
				if (!stroked) {
				   stroked=YES;
				   printf("stroke\n");
				}
				printf("%6.3f w\n",size);
				break;
		   default  : 	fprintf(stderr,"Unexpexted command\n");
				exit(2);
				break;
		}
		i=0;
	}
	if (conformingQ)
		printf("%%%%Trailer\n");
}

printtime()
/* print the time the plot was translated to PostScript */
{
	static int sdQ = NO;
	char *at;

	if( !sdQ ) {
	   sdQ = YES;
	   printf("\n%% Print the time the plot was converted to PostScript\n");
	   maketimestr(&at);
	   printf("/date ( %s ) def\n",at);
	   printf("sdate\n");
	   printf("%% End of print time\n\n");
	} else {
	   printf("sdate\n");
	}
}

maketimestr(s)
char **s;
{
	long time(),timep;
	struct tm *localtime(),*t;
	char *asctime();

	time(&timep);  /* get system time */
	t = localtime(&timep);
	*s = asctime(t);
	(*s)[24]='\0';  /* get rid of the return */
}

printheader()
{
	static int sentheader = NO;

	if (!sentheader) {
		sentheader =YES;
		printf("%% Header for every page\n");
		printf("/header (%s) def\n",hstring);
		printf("sheader\n");
		printf("%% End of set header\n");
	} else {
		printf("sheader\n");
	}
}

setotherfont()
{
	printf("%% set fonts\n");
	if ( eq(font,"cb") ) {
		printf("/RomanFont /Courier-Bold def\n");
		printf("/dlinew 10 def\n");
	} else if ( eq(font,"co") ) {
		printf("/RomanFont /Courier def\n");
		printf("/dlinew 4 def\n");
	} else if ( eq(font,"ho") ) {
		printf("/RomanFont /Helvetica-Oblique def\n");
		printf("/slant 0.1667 def\n");
	} else if ( eq(font,"tr") ) {
		printf("/RomanFont /Times-Roman def\n");
	} else {
		fprintf(stderr,"Unknown font choice. Try cb co ho tr\n");
	}
	printf("%% end of font setup\n\n");
}

isreal(t)
char *t;
{
	char ms[30],es[6],c,*ti;
	int exp,expresent;
	double mant;

	expresent=NO;

	/* store initial string pointer */
	ti = t;

	/* almost parse a real number */

	/* leading space is okay */
	while( *t != '\0' && isspace(*t) ) ++t;   /* skip white space */

	/* leading character better be a digit, sign, or decimal point */
    if   ( *t != '\0' && (isdigit(*t) || *t=='+' || *t=='-' || *t=='.') ) 
		++t;
	else
		return NO;

	while( *t != '\0' && isdigit(*t) ) ++t;
	while( *t != '\0' && ( *t=='.' ) ) ++t;
	while( *t != '\0' && isdigit(*t) ) ++t;

	/* saved what has been parsed */
	c=*t; *t='\0';
	strcpy(ms,ti);
	*t=c;

	/* check for exponent */
	if (*t=='e' || *t=='E' )
	{
		++t;
		/* first char after 'e' better be a digit or sign */
		if   ( *t == '\0' || !(isdigit(*t) || *t=='+' || *t=='-' ) ) 
			return NO;
		else
		{
			expresent = YES;
			strcpy(es,t);  /* save it */
			++t;
			while( *t != '\0' && isdigit(*t) ) ++t;
		}
	}
	
	/* trailing space is okay */
	while( *t != '\0' && isspace(*t) ) ++t; 

	/* if made it to the end then its a real */
	if (*t=='\0') {
		if (expresent) {
			sscanf(es,"%d",&exp);
			sprintf(es,"%-d",exp);
			sscanf(ms,"%lf",&mant);
			if (mant == 1.0 ) {
			  sprintf(ti,"10\\sp%s\\ep",es);
			} else {
			  sprintf(ti,"%s\\tm10\\sp%s\\ep",ms,es);
			}
		}
		return(YES);
	} else {
		return(NO);
	}
}


readopts(ac,av)
int ac;
char *av[];
{
	int c;
	extern int optind;
	extern char *optarg;
	FILE *fopen();

	while( (c=getopt(ac,av,"?edclp:f:h:")) != EOF) {
	  switch (c) {
		case 'd' :  printtimeQ=NO;
			    break;
		case 'e' :  forceepsQ=NO;
			    break;
		case 'c' :  printproQ=NO;
			    break;
		case 'l' :  landscapeQ = YES;
			    break;
		case 'p' :  printproQ=YES; optionproQ=YES;
		            proname=optarg;
			    break;
		case 'f' :  otherfontQ=YES;
			    font=optarg;
			    break;
		case 'h' :  printheaderQ=YES;
			    hstring=optarg;
			    break;
		case '?' :  fprintf(stderr,"xyps 1.0 patchlevel %-d\n",PATCHED);
			    exit(1);
			    break;
		default :   fprintf(stderr,"Unknown option %c\n",c);
			    exit(-1);
			    break;
	  }
	}

	if (optind<ac) {
		infile=fopen(av[optind],"r");
		if (infile==NULL) {
			fprintf(stderr,"Cannot open %s\n",av[optind]);
			exit(-1);
		}
	} else  {
		infile = stdin;
	}
}

#define CHUNKSTEP 	1000
#define BIGLINE		512
#define xconvert(x)	((x) * SCALE + TX )
#define yconvert(x)	((x) * SCALE + TY )

static char **lines;
static int total;

getxyin(file,box)
FILE *file;
BBOX *box;
{
	char *in;
	int chunk,i,j,c;
	extern int erasures;

	erasures=0;
	chunk=CHUNKSTEP;
	lines=(char **) malloc(sizeof(char *)*chunk);
	if(lines==NULL) gerror("No memory for lines");

	i=0;j=0;
	while((c=fgetc(file))!=EOF) {
		in=(char *) malloc(BIGLINE*sizeof(char));
		if(in==NULL) gerror("No memory for input");
		while((c==' ' || c=='\t') && c!=EOF && c!='\n') c=fgetc(file);
		in[i++]=c;
		while((c=fgetc(file))!=EOF && c!='\n') in[i++]=c;
		in[i]='\0';
		in=(char *) realloc((void *)in,sizeof(char)*(i+1));
		if (in==NULL) gerror("Reallocation error");
		if ( in[0] == 'e' ) ++erasures;
		if ( in[0] == 'b' ) {
			computebbox(in,box);
		} else {
			lines[j++]=in;
		}
		i=0;
		if (j>=chunk) {
			chunk += CHUNKSTEP;
			lines=(char **)realloc(
				    (void *)lines, sizeof(char *)*chunk );
			if(lines==NULL) gerror("Lines reallocation error");
		}
	}

	total=j;

	box->llx = xconvert(box->llx) - LX;
	box->lly = yconvert(box->lly) - LY;
	box->urx = xconvert(box->urx);
	box->ury = yconvert(box->ury);
}

char * nextline()
{
	static int linenumber=0;

	if(linenumber<total)
		return(lines[linenumber++]);
	else
		return(NULL);
}

gerror(s)
char *s;
{
	extern char *ProgName;

	fprintf(stderr,"%s: %s\n",ProgName,s);
	exit(-1);
}

computebbox(in,b)
char *in;
BBOX *b;
{
	static int firstQ=YES;
	int i1,i2,i3,i4;

	sscanf(in+1,"%d %d %d %d",&i1,&i2,&i3,&i4);
	if(firstQ) {
		b->llx=i1;
		b->lly=i2;
		b->urx=i3;
		b->ury=i4;
		firstQ=NO;
	} else {
		if (b->llx > i1 ) b->llx = i1;
		if (b->lly > i2 ) b->lly = i2;
		if (b->urx < i3 ) b->urx = i3;
		if (b->ury < i4 ) b->ury = i4;
	}

}
