
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/lib/RCS/skip.h,v 2.2 92/10/19 16:55:43 ken Exp $
 *
 * $Log:	skip.h,v $
 * Revision 2.2  92/10/19  16:55:43  ken
 * Trivial change
 * 
 * Revision 1.1  92/10/19  16:37:10  ken
 * Initial revision
 * 
 */

typedef struct _SLNode {
    void		*key;
    struct _SLNode	*forward[1];
} SLNode;

typedef struct _SkipListRec {
    SLNode	*header;
    SLNode	*last;
    int		(*compare)(void *, void *);
    int		unique;
    int		level;
    int		size;
} *SkipList;


typedef struct _StackRef {
    struct _StackNode	*node;
    int			distance;
} StackRef;

typedef struct _StackNode {
    void	*value;
    StackRef	forward[1];
} StackNode;

typedef struct _SkipStackRec {
    StackNode	*header;
    StackNode	*last;
    int		level;
    int		size;
} *SkipStack;


#define StackPush(l,v)		StackAppend(l,  0, v)
#define StackAddLast(l,v)	StackAppend(l, l->size, v)
#define StackPop(l)		StackRemove(l, 1)


/* Prototypes */

/* skip.c */
SkipList	SkipNew (int (*compare )(void *,void *), int unique);
void	SkipFreeData (SkipList l, void (*freeitem )(void *));
void	SkipFree (SkipList l, void (*freeitem )(void *));
int	SkipInsert (SkipList l, void *key);
void	*SkipRemove (SkipList l, void *key);
void	*SkipSearch (SkipList l, void *key);
void	*SkipHead (SkipList l);
void	*SkipNext (SkipList l);
int	SkipSize (SkipList l);
SkipStack	StackNew (void);
void	StackFreeData (SkipStack l, void (*freeitem )(void *));
void	StackFree (SkipStack l, void (*freeitem )(void *));
void	*StackSearch (SkipStack l, int k);
void	StackAppend (SkipStack l, int k, void *value);
void	*StackRemove (SkipStack l, int k);
void	*StackHead (SkipStack l);
void	*StackNext (SkipStack l);
int	StackSize (SkipStack l);
