
GVLUTIL		= $(TOP)/util
GVLLIB		= $(TOP)/lib
LIBGVL		= $(GVLLIB)/libgvl.a

INSTALL_BIN	= /usr/local/bin
INSTALL_MAN	= /usr/local/man/man1
INSTALL_DEF	= /usr/local/lib/X11/app-defaults

OBJ		= $(SRC:.c=.o)

#ifndef Library
INCLUDES	= -I$(GVLLIB)
#ifdef SGIArchitecture
MOTIF_LIB	= -lXm_s -lPW
#else
MOTIF_LIB	= -lXm
#endif

AllTarget($(APP))

NormalProgramTarget($(APP),$(OBJ),$(LIBGVL),$(LIB),-lm)

InstallProgram($(APP),$(INSTALL_BIN))
InstallManPage($(APP),$(INSTALL_MAN))
install		:: $(CLASS).ad
	$(INSTALL) -c $(INSTAPPFLAGS) $(CLASS).ad $(INSTALL_DEF)/$(CLASS)

$(LIBGVL)	:
	cd $(GVLLIB) ; $(MAKE) libgvl.a

#ifndef Debugging
DEFINES		= -DUSEFALLBACK
setup.o		: fallback.h
fallback.h	: $(CLASS).ad
	$(GVLUTIL)/mkfallback < $(CLASS).ad > fallback.h
#endif

#endif

#ifdef SGIArchitecture
CCOPTIONS	= -fullwarn -woff 24,269
LINTOPTS	= -u -woff 102
#endif

#ifdef Debugging
CDEBUGFLAGS	= -g
#endif

NormalLintTarget($(SRC))

etags		:
	etags -t *.[ch] "$(GVLLIB)/"*.[ch]

opt		: 
	$(IMAKE_CMD)
	$(MAKE)

debug		: 
	$(IMAKE_CMD) -DDebugging
	$(MAKE)

proto		: $(SRC)
	$(GVLUTIL)/protize $(SRC)

sdep		:
	@awk '/^# Dependencies/ {exit} {print}' Imakefile > Imakefile.tmp
	@echo '# Dependencies' >> Imakefile.tmp
	@gcc $(ALLDEFINES) -MM $(SRC) >> Imakefile.tmp
	@mv Imakefile.tmp Imakefile
#ifdef Debugging
	$(IMAKE_CMD) -DDebugging
#else
	$(IMAKE_CMD)
#endif
