#include <stdio.h>
#include <strings.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "vort.h"

#define	CMAPSIZE	256
#define	DEPTH		8
#define	MAX(a, b)	((a) > (b) ? (a) : (b))

extern	Notify_error	notify_dispatch();

Canvas		canvas;
Frame		frame;

Pixwin		*pw, *fpw, *tpw, *ppw;
Pixrect		*pr, **ppr;

Pixfont		*medium;

Panel		panel, tpanel;
Panel_item	fnum_item, tpanel_item;

int		dir,
		color = 1,
		cur_frame = -1,
		one = 1,
		fnum,
		stopped = 1,
		keep_going = 1,
		tlen = 0,
		do_titles = 0;

short		w, w2, h, oldw, oldh;

u_char		*red, *green, *blue;

char		*myname;
char		**title;

image		*im;

/*
 * program to read in a color-mapped image and display it on the sun
 */
main(ac, av)
	int	ac;
	char	**av;
{
	register int	ox, x, y;
	int		len, v, f;
	u_char		*line;
        caddr_t         l;
        caddr_t         p;
        int             line_bytes;
	int		upsidedown;

	if ((myname = rindex(av[0],'/')) == NULL)
		myname = av[0];
	else
		*myname++;
	/*
	 * Chech that we are in sunview....
	 */
	if (getenv("WINDOW_ME") == NULL) {
		fprintf(stderr, "%s can only be run under sunview (suntools).\n", myname);
		exit(1);
	}

	if (ac < 2) {
		fprintf(stderr, "usage: %s [-t] [-u] files\n", myname);
		exit(1);
	}

	do_titles = 0;
	upsidedown = 0;

	for (f = 1; f < ac && *av[f] == '-'; f++) {
		if (strcmp(av[f], "-t") == 0) {
			do_titles = 1;
		} else if (strcmp(av[f], "-u") == 0) {
			upsidedown = 1;
		}
	}

        medium = pf_open("/usr/lib/fonts/fixedwidthfonts/cour.b.16");


	/*
	 * Read in a bunch of images into pixrects
	 *
	 * First allocate a bunch of pixrect pointers
	 */

	ppr = (Pixrect **)malloc(sizeof(Pixrect *) * (ac - f));

	if (do_titles) 
		title = (char **)malloc(sizeof(char *) * (ac - f));
		
	for (fnum = f; fnum < ac; fnum++) {
		if ((im = openimage(av[fnum], "r")) == (image *)NULL) {
			fprintf(stderr, "%s: can't open file %s.\n", myname, av[fnum]);
			exit(1);
		}

		fprintf(stderr, "Reading file %s\n", av[fnum]);

		len = titlelength(im);
		tlen = MAX(tlen, len);

		w = imagewidth(im);
		h = imageheight(im);

		w2 = w;
		if ((x = w % 4) != 0)
			w2 = (w / 4 + x) * 4;

		if (one) {
			one = 0;
			oldw = w;
			oldh = h;
			line = (u_char *)malloc(w);
			l = (caddr_t)line;
			if (!colormapped(im)) {
				color = 0;
				if (w < CMAPSIZE) {
					red = (u_char *)malloc(CMAPSIZE);
					green = (u_char *)malloc(CMAPSIZE);
					blue = (u_char *)malloc(CMAPSIZE);
				} else {
					red = (u_char *)malloc(w);
					green = (u_char *)malloc(w);
					blue = (u_char *)malloc(w);
				}
			}
		} else if (oldw != w || oldh != h) {
			fprintf(stderr, "All images must be the same size\n");
			exit(1);
		}


		if (do_titles) {
			if (len != 0) {
				title[fnum - f] = (char *)malloc((unsigned)len);
				strcpy(title[fnum - f], imagetitle(im));
			} else {
				title[fnum - f] = (char *)malloc(1);
				title[fnum - f][0] = '\0';
			}
		}

		/*
		 * Allocate the pixrect for this frame 
		 */
		if ((pr = ppr[fnum - f] = mem_create(w2, h, DEPTH)) == (Pixrect *)NULL) {
			fprintf(stderr, "Failed to allocate Pixrect for frame %d\n", fnum);
			break;
		}

		line_bytes = mpr_linebytes(w2, DEPTH);
		p = (caddr_t)mpr_d(pr)->md_image; /* Start of Pixrect */

		if (upsidedown)
			p += line_bytes * (h - 1);      /* Last line in Pixrect */

		y = h - 1;
		x = 0;

		if (color) {
			while (y >= 0) {
				readmappedline(im, line);
				bcopy(l, p, line_bytes);	/* Quite fast */
				if (upsidedown)
					p -= line_bytes;		/* Backwards */
				else
					p += line_bytes;
				y--;
			}
		} else {
			while (y >= 0) {
				readrgbline(im, red, green, blue);
				for (x = 0; x < w; x++) 
					line[x] = red[x] * 0.3 + green[x] * 0.59 + blue[x] * 0.11;

				bcopy(l, p, line_bytes);	/* Quite fast */
				if (upsidedown)
					p -= line_bytes;		/* Backwards */
				else
					p += line_bytes;
				y--;
			}
		}

		if (fnum < ac - 1)
			closeimage(im);
	}
	fprintf(stderr, "Finished reading %d files.\n", fnum - f);

	fnum -= f;

	if (tlen <= 0)
		do_titles = 0;

	init(w, h);
	closeimage(im);

	window_set(frame, WIN_SHOW, TRUE, 0);
	
	dir = 1;
	show_frame();

	/*
	 * Uses explicit sunview dispatching
	 */
	while (keep_going) {
		(void)notify_dispatch();
		while (!stopped) {
			show_frame();
			(void)notify_dispatch();
		}
	}

}

show_frame()
{
	char	buf[20];

	cur_frame += dir;
	if (cur_frame >= fnum)
		cur_frame = 0;
	else if (cur_frame < 0)
		cur_frame = fnum - 1;

	sprintf(buf, "Frame: %d\n", cur_frame);
	pw_batch_on(pw);
	pw_rop(pw, 0, 0, w, h, PIX_SRC | PIX_DONTCLIP, ppr[cur_frame], 0, 0);
	pw_batch_off(pw);
	panel_set(fnum_item, PANEL_LABEL_STRING, buf, 0);

	if (do_titles) {
		panel_set(tpanel_item, PANEL_LABEL_STRING, title[cur_frame], 0);
	}
}

stop()
{
	stopped = 1;
}

start()
{
	stopped = 0;
}

Notify_value
exterminate(frame, status)
	Frame		frame;
	Destroy_status	status;
{
	if (status != DESTROY_CHECKING) {
		keep_going = 0;
		stopped = 1;
		(void)notify_stop();
	}

	return (notify_next_destroy_func(frame, status));
}

quit()
{
/*
        DESTROY_PROCESS_DEATH=0,
        DESTROY_CHECKING=1,
        DESTROY_CLEANUP=2,
*/

	notify_post_destroy(frame, DESTROY_CHECKING, NOTIFY_SAFE);
	notify_post_destroy(frame, DESTROY_CLEANUP, NOTIFY_SAFE);
	exit(0);
}

reverse()
{	
	dir = -1;
	if (stopped)
		show_frame();
}

forward()
{	
	dir = 1;
	if (stopped)
		show_frame();
}

init(w, h)
	int	w, h;
{
	int	i;
	char	buf[30];

	strcpy(buf, myname);
	strcat(buf, ".vo");

	frame = window_create(NULL, FRAME,
		FRAME_LABEL, buf,
		WIN_FIT_HEIGHT, 3,
	0);

	(void)notify_interpose_destroy_func(frame, exterminate);

	fpw = (Pixwin *)window_get(frame, WIN_PIXWIN);

	panel = window_create(frame, PANEL, 
			WIN_FONT, medium,
			WIN_HEIGHT, 30,
/*
			WIN_X, 1, 
			WIN_Y, 3,
*/
	0);

	ppw = (Pixwin *)window_get(panel, WIN_PIXWIN);


	panel_create_item(
		panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,
		panel_button_image(panel, "<<", 0, 0),
		PANEL_NOTIFY_PROC, reverse,
	0);

	panel_create_item(
		panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,
		panel_button_image(panel, "Play", 0, 0),
		PANEL_NOTIFY_PROC, start,
	0);

	panel_create_item(
		panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,
		panel_button_image(panel, ">>", 0, 0),
		PANEL_NOTIFY_PROC, forward,
	0);

	panel_create_item(
		panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,
		panel_button_image(panel, "Stop", 0, 0),
		PANEL_NOTIFY_PROC, stop,
	0);

	fnum_item = panel_create_item(
			panel, PANEL_MESSAGE,
			PANEL_LABEL_STRING, "Frame: 0  ",
		    0);

	panel_create_item(
		panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,
		panel_button_image(panel, " QUIT ", 0, 0),
		PANEL_NOTIFY_PROC, quit,
	0);


	canvas = window_create(frame, CANVAS,
			/*CANVAS_RETAINED, TRUE,*/
			WIN_HEIGHT, h,
			WIN_WIDTH, w,
			WIN_X, 1, 
			WIN_Y, 39,
		0);

	pw = (Pixwin *)canvas_pixwin(canvas);

	if (do_titles) {
		tpanel = window_create(frame, PANEL, 
				WIN_FONT, medium,
				WIN_HEIGHT, 30,
				WIN_X, 1, 
				WIN_Y, 45 + h,
		0);

		tpw = (Pixwin *)window_get(tpanel, WIN_PIXWIN);

		tlen--;
		for (i = 0; i < tlen; i++)
			buf[i] = ' ';

		buf[tlen] = '\0';

		tpanel_item = panel_create_item(
				tpanel, PANEL_MESSAGE,
				PANEL_LABEL_STRING, buf,
			    0);
	}

	window_fit(panel);
	window_fit(canvas);

	if (do_titles)
		window_fit(tpanel);

	window_fit(frame);

	if (color) {
		setcolors(cmapsize(im), redmap(im), greenmap(im), bluemap(im));
	} else {

		for (i = 0; i < CMAPSIZE; i++)
			red[i] = green[i] = blue[i] = i;

		setcolors(CMAPSIZE, red, green, blue);
	}
}

setcolors(n, red, green, blue)
	int	n;
	u_char	*red, *green, *blue;
{
	char	buf[40];
	sprintf(buf, "movie%d", getpid());

	pw_setcmsname(fpw, buf);
        pw_putcolormap(fpw, 0, n, red, green, blue);

	if (do_titles) {
		pw_setcmsname(tpw, buf);
		pw_putcolormap(tpw, 0, n, red, green, blue);
	}

	pw_setcmsname(ppw, buf);
        pw_putcolormap(ppw, 0, n, red, green, blue);

	pw_setcmsname(pw, buf);
        pw_putcolormap(pw, 0, n, red, green, blue);
}
