;       Extra segment management
;
;       toextra()
;       fromextra()
;       cmpextra()
;

        .MODEL  medium,c

        .8086

.DATA

; ************************ External variables *****************************

; ************************ Public variables *****************************

public          extraseg                ; extra 64K segment, if any

;               arrays declared here, used elsewhere

public          strlocn, entrynum, teststring   ; used by the Encoder

; ************************* "Shared" array areas **************************

strlocn         db      8192 dup(0)     ; 8K Encoder array

entrynum        db      8192 dup(0)     ; 8K Encoder array

teststring      db      100  dup(0)     ; 100 byte Encoder array

; ************************ Internal variables *****************************

extraseg        dw      0               ; extra 64K segment (allocated by init)


.CODE

; *************** Function toextra(tooffset,fromaddr, fromcount) *********

public toextra
toextra proc    uses es di si, tooffset:word, fromaddr:word, fromcount:word
        cmp     extraseg,0              ; IS there extra memory?
        je      tobad                   ;  nope.  too bad.
        cld                             ; move forward
        mov     ax,extraseg             ; load ES == extra segment
        mov     es,ax                   ;  ..
        mov     di,tooffset             ; load to here
        mov     si,fromaddr             ; load from here
        mov     cx,fromcount            ; this many bytes
        rep     movsb                   ; do it.
tobad:
        ret                             ; we done.
toextra endp


; *************** Function fromextra(fromoffset, toaddr, tocount) *********

public fromextra
fromextra proc  uses es di si, fromoffset:word, toaddr:word, tocount:word
        push    ds                      ; save DS for a tad
        pop     es                      ; restore it to ES
        cmp     extraseg,0              ; IS there extra memory?
        je      frombad                 ;  nope.  too bad.
        cld                             ; move forward
        mov     ax,extraseg             ; load DS == extra segment
        mov     ds,ax                   ;  ..
        mov     si,fromoffset           ; load from here
        mov     di,toaddr               ; load to here
        mov     cx,tocount              ; this many bytes
        rep     movsb                   ; do it.
frombad:
        push    es                      ; save ES again.
        pop     ds                      ; restore DS
        ret                             ; we done.
fromextra endp


; *************** Function cmpextra(cmpoffset,cmpaddr, cmpcount) *********

public cmpextra
cmpextra proc   uses es di si, cmpoffset:word, cmpaddr:word, cmpcount:word
        cmp     extraseg,0              ; IS there extra memory?
        je      cmpbad                  ;  nope.  too bad.
        cld                             ; move forward
        mov     ax,extraseg             ; load ES == extra segment
        mov     es,ax                   ;  ..
        mov     di,cmpoffset            ; load to here
        mov     si,cmpaddr              ; load from here
        mov     cx,cmpcount             ; this many bytes
        rep     cmpsb                   ; do it.
        jnz     cmpbad                  ; failed.
        mov     ax,0                    ; 0 == true
        jmp     cmpend
cmpbad:
        mov     ax,1                    ; 1 == false
cmpend:
        ret                             ; we done.
cmpextra        endp

        end
