#include <stdio.h>
#include <math.h>
#ifdef PC
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#define rindex strrchr
#else
#ifdef SYSV
#include <fcntl.h>
#else
#ifdef VMS
#include <types.h>
#include <file.h>
#else
#include <sys/types.h>
#include <sys/file.h>
#endif
#endif
#endif
#ifdef VMS
#include <string.h>
#define rindex strrchr
#endif
#ifdef MIPS
#include <string.h>
#define rindex strrchr
#endif
#ifdef PC
#ifdef TC
#include <time.h>
#ifdef _STKLEN
unsigned _stklen = _STKLEN;
#else
unsigned _stklen = 8192 * 2 * 2;
#endif
#else
#include <sys/timeb.h>
#endif
#else
#include <sys/times.h>
#endif
#ifdef CRAY
#include <string.h>
#define rindex strrchr
#endif

#include "art.h"
#include "objs.h"
#include "macro.h"
#include "gram.h"
#include "random.h"

extern char	*rindex();
extern hlist	*trace();
extern void	shade();
extern time_t	time();

extern object	*treeinit();

#ifndef VMS
FILE	*logfile = stdout;
#else
FILE	*logfile;
#endif

int	linecount;		/* line counter for parser */

object	*oblist;		/* object list */
object	*treeobjs, *otherobjs;	/* bsp-able and non-bsp-able objects */

light	*lights;		/* lights list */

objst	*ostackp;		/* object def stack */

attr	*astackp;		/* attribute stack */

mats	*mstackp;		/* transformation stack */

char	*title;			/* title of picture */

char	currentfile[MESLEN];	/* name of current "input" file */

int	perspective = TRUE;	/* projection - perspective or orthographic */
int	raysperpix = 1;		/* number of rays per pixel */
int	maxhitlevel = 6;	/* max number of rays traced in reflection */
long	filetype = PIX_RLE;	/* output file format */

short	raynumber = 1;		/* initial raynumber */

float	screenx = 1.0,		/* half screen width */
	screeny = 1.0;		/* half screen height */

float	tolerance;		/* tolerance value */

int	maxtreedepth = 35;	/* max depth for kd tree */

/*
 * ambient colour and background pixel stuff
 */
colour	ambient;
colour	backcol = { 0.0, 0.0, 0.0 };

/*
 * light falloff
 */
float	falloff = 0.0;

/*
 * global refractive index
 */
float	ri = 1.0;

/*
 * pointer to the free list for hit structures
 */
hlist	*fhlist;

/*
 * details for the primary rays
 */
vector	org;

vector	up = { 0.0, 1.0, 0.0 };

float	focallength = -1.0;

matrix	trans = {
	1.0, 0.0, 0.0, 0.0,
	0.0, 1.0, 0.0, 0.0,
	0.0, 0.0, 1.0, 0.0,
	0.0, 0.0, 0.0, 1.0
};

/*
 * shading stack
 */
shadedata	*sstack, *sstackp;

/*
 * haze stuff
 */
float	fogfactor = 0.0,		/* the fog factor */
	rfactor = 0.03;			/* the mysterious "r" factor */


colour	hazecolour = { 1.0, 1.0, 1.0 };	/* the haze colour */

float	sourceradius;		/* For ripple texture */

/*
 * temporary file pointer
 */
char	*tmpname;

/*
 * random number pointers
 */
float	*randp = randtable,
	*erandp = &randtable[sizeof(randtable) / sizeof(float)];

/*
 * function pointer tables for intersections, normals, etc...
 */
hlist	*(*intersects[NUM_OBJS])();
void	(*normal[NUM_OBJS])();
void	(*tilefun[NUM_OBJS])();

int	checkbbox[NUM_OBJS];	/* should we check bounding box of this type */
int	selfshadowing[NUM_OBJS];	/* is this object self shadowing? */

/*
 * x, y offsets, scale, and sampleing
 */
static int	xoff, yoff;
static float	xscale, yscale;
static int	ysperpix, xsperpix;

/*
 * frame id extension and frame number
 */
char	*frameid = "000";
int	frameno = 0;

/*
 * default name
 */
char	*defname = "pic.pix";

int shadow_rays	= FALSE;		/* are rays for shadow testing? */
 
/*
 * antialiasing stuff
 */
int		pixelgrid = FALSE;	/* pixel grid on or off */
static int	extrarays,      	/* spare rays for jittering */
		totrays;        	/* total number of rays per pixel */

static pixel	*topline;       /* scanline of sample grid at top of current scanline */

static pixel	others[2];      /* bottom 2 samples of pixel grid */

static float	averagefactor;	/* number to divide final samples through by */
			      
/*
 * statistics stuff
 */
#ifdef STATS
static int	totnodes;
static int	totleafs;
static int	neverentered;
static int	maxfinaldepth;
static int	maxinleaf;
static int	mininleaf;
static int	emptynodes;
static int	numobjptrs;
#endif

#ifdef TIME_STATS
static float    prev_time;
static time_t  start_time, rprev_time, tstart_time;
static struct tms       buffer;
#endif

#ifdef PC
int	EMS_available = FALSE;
void	ctrl_C(void);	/* CTRL-C trap processor */

#endif

static int	totobjs;

extern FILE	*yyin;

/*
 * debugging flag.
 */
int	debug = FALSE;

/*
 * usage
 *
 *	the usage message - in this case a do nothing operation.
 */
usage()
{
}

/*
 * readshort
 *
 *      read a short value from a socket.
 */
int
readshort(sock)
	int	sock;
{
	unsigned short  val;
	int		count;

	count = 0;

	while ((count += read(sock, (char *)&val + count, sizeof(unsigned short) - count)) != sizeof(unsigned short) && count >= 0)
		;
		
	return((int)ntohs(val));
}

/*
 * main driver
 */
main(ac, av)
	int	ac;
	char	*av[];
{
	int		y, x, len, indx, standardin, preprocess, nameset;
	char		c, *p, name[BUFSIZ], buf[BUFSIZ], path[BUFSIZ];
	char		scenename[BUFSIZ];
	image		*im;
	FILE		*infile, *logf;
	unsigned char	*red, *green, *blue, *alpha, *map;
	int		i, fragment, xsize, ysize, xstart, xend, ystart, yend;
	int		xfrag, yfrag;
	object		*o, *nexto;
	float		k1, k2;
	expression	*e;
#ifdef LOSINGTRACK
	char		hostname[65], pathname[513];
#endif

#ifdef TIME_STATS
	times(&buffer);
	start_time = buffer.tms_utime + buffer.tms_stime;
#endif

	logf = fopen("/tmp/dartlog", "w");

	logfile = logf;

	/*
	 * read in working directory for art
	 */
	len = readshort(0);

	read(0, path, len);
	path[len] = 0;

	chdir(path);
	sprintf(buf, "%s\n", path);
	message(buf);

	/*
	 * read in name of scene file
	 */
	len = readshort(0);

	read(0, scenename, len);
	name[len] = 0;
	sprintf(buf, "%s\n", scenename);
	message(buf);

	/*
	 * get size of total image in pixels.
	 */
	xsize = readshort(0);
	ysize = readshort(0);

	/*
	 * get flags
	 */
	preprocess = readshort(0);

	sprintf(buf, "image size %d %d\n", xsize, ysize);
	message(buf);
	fflush(logf);

	xstart = 0;
	xend = xsize - 1;

	ystart = ysize - 1;
	yend = 0;

#ifndef OLDFOV
	if (xsize > ysize)
		focallength = -(float)xsize / (float)ysize;
	else
		focallength = -(float)ysize / (float)xsize;
#endif

	nameset = FALSE;
	standardin = FALSE;
	fragment = FALSE;
					/* check for other options */
	sourceradius = 100.0;

	mstackp = (mats *)smalloc(sizeof(mats));
	mident4(mstackp->d.om);
	mident4(mstackp->d.vm);
	mident4(mstackp->d.obj2ray);
	mident4(mstackp->d.ray2obj);
	mstackp->d.maxscale = 1.0;
	mstackp->d.nscales.x = mstackp->d.nscales.y = mstackp->d.nscales.z = 1.0;

	mstackp->lst = mstackp->nxt = (mats *)NULL;

	astackp = (attr *)smalloc(sizeof(attr));

	astackp->d.s = (surface *)smalloc(sizeof(surface));
	astackp->d.s->falloff = 0.0;
	astackp->d.s->trans.r = astackp->d.s->trans.g = 0.0;
	astackp->d.s->trans.b = 0.0;
	astackp->d.s->refl.r = astackp->d.s->refl.g = 0.0;
	astackp->d.s->refl.b = 0.0;
	astackp->d.s->c.r = astackp->d.s->c.g = astackp->d.s->c.b = 1.0;
	astackp->d.s->a.r = astackp->d.s->a.g = astackp->d.s->a.b = 0.1;
	astackp->d.s->ri = astackp->d.s->kd = 1.0;
	astackp->d.s->ks = 0.0;
	astackp->d.s->shadows = TRUE;
	astackp->d.txtlist = (texture *)NULL;
	astackp->d.shadows = TRUE;
	astackp->d.slevel = 0;

	astackp->lst = astackp->nxt = (attr *)NULL;

	ostackp = (objst *)smalloc(sizeof(objst));
	ostackp->sym = (symbol *)NULL;

	ostackp->lst = ostackp->nxt = (objst *)NULL;

	linecount = 1;

	if (nameset) {
		strcpy(name, defname);

		if ((p = rindex(name, '.')) == (char *)NULL)
			fatal("art: output file should end with \".pix\".\n");
	} else {
		strcpy(name, scenename);

		if ((p = rindex(name, '.')) == (char *)NULL)
			fatal("art: input file should end with \".scn\".\n");
		standardin = FALSE;
	}

#ifdef LOSINGTRACK
	gethostname(hostname, 64);
	getwd(pathname, 512);
	fprintf(logfile, "Host: %s	Directory: %s\n", hostname, pathname);
	fflush(logfile);
#endif

	if (preprocess) {
		sprintf(name, "/tmp/%sXXXXXX", scenename);
		mktemp(name);

		if ((infile = fopen(name, "w")) == NULL) {
			sprintf(buf, "art: unable to open temporary file %s.\n", name);
			fatal(buf);
		}

		prepro(scenename, infile);

		fclose(infile);
	} else
		strcpy(name, scenename);

	/*
	 * initialise variable symbol table
	 */
	e = (expression *)smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'x';
	defvar("x", e);

	e = (expression *)smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'y';
	defvar("y", e);

	e = (expression *)smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'z';
	defvar("z", e);

	/*
	 * initialise object symbol table
	 */
	defobj("geometry", GEOMETRY, (details *)NULL);
	defobj("sphere", SPHERE, (details *)NULL);
	defobj("ellipsoid", ELLIPSOID, (details *)NULL);
	defobj("box", BOX, (details *)NULL);
	defobj("torus", TORUS, (details *)NULL);
	defobj("algebraic", ALGEBRAIC, (details *)NULL);
	defobj("cylinder", CYLINDER, (details *)NULL);
	defobj("cone", CONE, (details *)NULL);
	defobj("superquadric", SUPERQUADRIC, (details *)NULL);
	defobj("ring", RING, (details *)NULL);
	defobj("disk", RING, (details *)NULL);
	defobj("light", LIGHT, (details *)NULL);
	defobj("polygon", POLYGON, (details *)NULL);

	if (preprocess)
		tmpname = name;
	else
		tmpname = (char *)NULL;

	if ((yyin = fopen(name, "r")) != (FILE *)NULL) {
		fflush(logf);
		if (preprocess)
			unlink(name);

		yyparse();
		fflush(logf);

		fclose(yyin);
	} else {
		sprintf(buf, "in.artd: unable to open file %s.\n", name);
		fatal(buf);
	}

	

#ifdef TIME_STATS
	printtime("Preprocessing time		:");
#endif

	/*
	 * initialise shade stack
	 */
	sstack = (shadedata *)scalloc(sizeof(shadedata), maxhitlevel);

	sstack[0].ri = ri;
	sstack[0].falloff = falloff;

	sstackp = sstack;

	treeobjs = otherobjs = (object *)NULL;

	for (o = oblist; o != (object *)NULL; o = nexto) {
		nexto = o->nxt;
		if (o->type == ALGEBRAIC) {
			o->nxt = otherobjs;
			otherobjs = o;
			totobjs++;
		} else if (o->type == NULL_OBJ) 
			free(o);
		else {
			o->nxt = treeobjs;
			treeobjs = o;
			totobjs++;
		}
	}

	if (treeobjs != (object *)NULL) {
		oblist = treeinit(treeobjs);

		tolerance = sqrt(sqr(oblist->bb.max[X] - oblist->bb.min[X]) + sqr(oblist->bb.max[Y] - oblist->bb.min[Y]) + sqr(oblist->bb.max[Z] - oblist->bb.min[Z])) / 2.0 * TOLERANCE;

		for (o = treeobjs; o != (object *)NULL; o = o->nxt) {
			o->bb.min[X] -= tolerance;
			o->bb.min[Y] -= tolerance;
			o->bb.min[Z] -= tolerance;

			o->bb.max[X] += tolerance;
			o->bb.max[Y] += tolerance;
			o->bb.max[Z] += tolerance;
		}

		oblist->obj.tree->bb.min[X] -= tolerance;
		oblist->obj.tree->bb.min[Y] -= tolerance;
		oblist->obj.tree->bb.min[Z] -= tolerance;

		oblist->obj.tree->bb.max[X] += tolerance;
		oblist->obj.tree->bb.max[Y] += tolerance;
		oblist->obj.tree->bb.max[Z] += tolerance;

		oblist->nxt = otherobjs;
	} else {
		oblist = otherobjs;
		tolerance = TOLERANCE;
	}

	/*
	 * set up intersection and normal function pointers
	 */
	spheretabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	boxtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	torustabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	cyltabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	conetabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	ellipstabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	geomtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	polytabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	supertabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	ringtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	csgtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	algtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	hfieldtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	treetabinit(intersects, normal, tilefun, checkbbox, selfshadowing);

	strcpy(p, PIX_SUFFIX);

	imagebufsize(512);
	if ((im = openimage(name, "w")) == (image *)NULL) {
		sprintf(buf, "art: unable to open %s for writing\n", name);
		fatal(buf);
	}

	imagetype(im) = filetype;

	imagewidth(im) = xend - xstart + 1;
	imageheight(im) = ystart - yend + 1;

	imagedepth(im) = 24;

	imagedate(im) = time((time_t *)NULL);

	imagebackgnd(im).r = backcol.r * 255.0;
	imagebackgnd(im).g = backcol.g * 255.0;
	imagebackgnd(im).b = backcol.b * 255.0;

	if (title == (char *)NULL)
		titlelength(im) = 0;
	else {
		titlelength(im) = strlen(title) + 1;
		imagetitle(im) = title;
	}

	if (fragment) {
		imagefragment(im) = TRUE;
		imagexaddr(im) = xstart;
		imageyaddr(im) = ysize - 1 - ystart;
		imageorigwidth(im) = xsize;
		imageorigheight(im) = ysize;
	}

	writeheader(im);

	xoff = xsize / 2;
	yoff = ysize / 2;

	if (xsize > ysize)
		xscale = yscale = ysize / 2;
	else
		xscale = yscale = xsize / 2;

	red = (unsigned char *)scalloc(xsize, 1);
	green = (unsigned char *)scalloc(xsize, 1);
	blue = (unsigned char *)scalloc(xsize, 1);
	alpha = (unsigned char *)scalloc(xsize, 1);

	if (oblist != (object *)NULL)
		sprintf(buf, "world bounding box: %+11.4f %+11.4f %+11.4f\n                    %+11.4f %+11.4f %+11.4f\n",
		oblist->obj.tree->bb.min[X], oblist->obj.tree->bb.min[Y], oblist->obj.tree->bb.min[Z],
		oblist->obj.tree->bb.max[X] , oblist->obj.tree->bb.max[Y] , oblist->obj.tree->bb.max[Z]);

	message(buf);


	xfrag = readshort(0);
	yfrag = readshort(0);

	fprintf(logf, "frag size %d %d\n", xfrag, yfrag);
	fflush(logf);

#ifdef TIME_STATS
	times(&buffer);
	tstart_time = buffer.tms_utime + buffer.tms_stime;
#endif

	map = (unsigned char *)smalloc(xfrag * yfrag * 3);

	read(0, &c, 1);

	map = (unsigned char *)smalloc(xfrag * yfrag * 4);
	topline = (pixel *)scalloc(sizeof(pixel), xsize + 3);

	while (c != 'Q') {
		xstart = readshort(0);
		xend = readshort(0);

		ystart = ysize - readshort(0);
		yend = ysize - readshort(0);

		if (pixelgrid) {
			extrarays = raysperpix - 1;
			totrays = extrarays + 4;

			averagefactor = 255.0 / totrays;

			k2 = (ystart + 1 - yoff) / yscale;

			for (i = xstart; i <= xend + 1; i++)
				gensample((i - xoff) / xscale, k2, &topline[i]);

			k1 = (xstart - xoff) / xscale;

			for (y = ystart; y >= yend; y--) {

				gensample(k1, (y - yoff) / yscale, &others[0]);

				for (x = xstart; x <= xend; x++) {
					dotrace2(x, y, &red[x - xstart], &green[x - xstart], &blue[x - xstart], &alpha[x - xstart]);
				}

				for (x = xstart; x <= xend; x++) {
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4] = red[x - xstart];
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4 + 1] = green[x - xstart];
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4 + 2] = blue[x - xstart];
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4 + 3] = alpha[x - xstart];
				}

				topline[xend + 1] = others[1];
			}

		} else {
			for (y = ystart; y >= yend; y--) {

				for (x = xstart; x <= xend; x++)
					dotrace1(x, y, &red[x - xstart], &green[x - xstart], &blue[x - xstart], &alpha[x - xstart]);

				for (x = xstart; x <= xend; x++) {
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4] = red[x - xstart];
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4 + 1] = green[x - xstart];
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4 + 2] = blue[x - xstart];
					map[((ystart - y) * (xend - xstart + 1) + x - xstart) * 4 + 3] = alpha[x - xstart];
				}
			}
		}

		fprintf(logf, "%c - %d %d %d %d\n", c, xstart, xend, ystart, yend);
		fflush(logf);
		write(1, "D", 1);

		write(1, map, xfrag * yfrag * 4);

		read(0, &c, 1);
	}

#ifdef PC
	/* deallocate storage used by tile patterns, esp. EMS */
	uninit_tiles();
#endif

	closeimage(im);

#ifdef TIME_STATS
	printtime("Total time taken		:");
#endif

#ifdef STATS
	sprintf(buf, "Total number of objects		: %d\n", totobjs);
	message(buf);

	if (treeobjs != (object *)NULL) {
		mininleaf = totobjs;

		getstats(oblist->obj.tree);

		sprintf(buf, "Total number of tree nodes	: %d\n", totnodes);
		message(buf);
		sprintf(buf, "Number of leaf nodes not entered: %d\n", neverentered);
		message(buf);
		sprintf(buf, "Number of leaf nodes entered	: %d\n", totleafs);
		message(buf);
		sprintf(buf, "Number of object pointers	: %d\n", numobjptrs);
		message(buf);
		sprintf(buf, "Min number of objects in a leaf	: %d\n", mininleaf);
		message(buf);
		sprintf(buf, "Max number of objects in a leaf	: %d\n", maxinleaf);
		message(buf);
		sprintf(buf, "Max depth of a leaf node	: %d\n", maxfinaldepth);
		message(buf);
		sprintf(buf, "Number of empty nodes		: %d\n", emptynodes);
		message(buf);
	}
#endif

	exit(ALLOK);
}

/*
 * gensample
 *
 *	generate a sample value for a given ray
 */
gensample(k1, k2, sample)
	float	k1, k2;
	pixel	*sample;
{
	ray	ir;
	hlist	*hit, *lp, *p;
	float	fact;

	if (perspective) {
		ir.org.x = ir.dir.x = k1;
		ir.org.y = ir.dir.y = k2;
		
		ir.org.z = 0.0;
		ir.dir.z = focallength;
		normalise(ir.dir);
	} else {
		ir.org.x = k1;
		ir.org.y = k2;
		ir.org.z = 0.0;

		ir.dir.x = 0.0;
		ir.dir.y = 0.0;
		ir.dir.z = -1.0;
	}

	ir.org.x *= screenx;
	ir.org.y *= screeny;

	ir.ri = ri;
	ir.type = PRIMARY_RAY;
	ir.raynumber = raynumber++;

	ir.orgobj = (object *)NULL;

	if ((hit = trace(&ir, oblist)) != (hlist *)NULL) {
		shade(sample, &ir, hit, 0);
		sample->a = 1.0;
	} else {
		sample->r = backcol.r;
		sample->g = backcol.g;
		sample->b = backcol.b;
		sample->a = 0.0;
	}

	for (lp = hit; lp != (hlist *)NULL; lp = p) {
		p = lp->nxt;
		release(lp);
	}
}

/*
 * dotrace1
 *
 *	Generate a straight no-nonsense sampling for the image, if you
 * like weird filters and postprocessing this is the one for you!
 */
dotrace1(x, y, r, g, b, a)
	int		x, y;
	unsigned char	*r, *g, *b, *a;
{
	pixel	pix;
	object	*o;

	gensample((x - xoff + 0.5) / xscale, (y - yoff + 0.5) / yscale, &pix);

	if (raynumber < 0) {
		for (o = treeobjs; o != (object *)NULL; o = o->nxt)
			o->lastray.raynumber = 0;
		raynumber = 1;
	}

	*r = pix.r * 255.0;
	*g = pix.g * 255.0;
	*b = pix.b * 255.0;
	*a = pix.a * 255.0;
}

/*
 * dotrace2
 *
 *	traces the neccessary number of rays and calculates r,
 * g, b, and alpha info averaging the samples at the end.
 */
dotrace2(x, y, r, g, b, a)
	int		x, y;
	unsigned char	*r, *g, *b, *a;
{
	int	i;
	pixel	sample;
	float	red, green, blue, alpha;
	object	*o;

	red = green = blue = alpha = 0.0;

	gensample((x + 1 - xoff) / xscale, (y - yoff) / yscale, &others[1]);

	red = (topline[x].r + topline[x + 1].r + others[0].r + others[1].r);
	green = (topline[x].g + topline[x + 1].g + others[0].g + others[1].g);
	blue = (topline[x].b + topline[x + 1].b + others[0].b + others[1].b);
	alpha = (topline[x].a + topline[x + 1].a + others[0].a + others[1].a);

	topline[x] = others[0];
	others[0] = others[1];

	if (extrarays) {
		gensample((x - xoff + 0.5) / xscale, (y - yoff + 0.5) / yscale, &sample);
		red += sample.r;
		green += sample.g;
		blue += sample.b;
		alpha += sample.a;

		for (i = 1; i != extrarays; i++) {
			gensample((x - xoff + randnum()) / xscale, (y - yoff + randnum()) / yscale, &sample);

			red += sample.r;
			green += sample.g;
			blue += sample.b;
			alpha += sample.a;
		}
	}

	if (alpha != 0.0) {
		*r = red * averagefactor + randnum();
		*g = green * averagefactor + randnum();
		*b = blue * averagefactor + randnum();
		*a = alpha * averagefactor;
	} else {
		*r = red * averagefactor;
		*g = green * averagefactor;
		*b = blue * averagefactor;
		*a = alpha * averagefactor;
	}

	if (raynumber < 0) {
		for (o = treeobjs; o != (object *)NULL; o = o->nxt)
			o->lastray.raynumber = 0;
		raynumber = 1;
	}
}

#ifdef STATS
/*
 * getstats
 *
 *	calculate the statistics for the kd-tree pointed to by 
 * root.
 */
getstats(root)
	stree	*root;
{
	olist	*obs;
	int	count;

	totnodes++;

	if (root->type == SPLITABLELEAF)
		neverentered++;
	else if (root->type == LEAF) {
		if (maxfinaldepth < root->u.leaf.depth)
			maxfinaldepth = root->u.leaf.depth;
		if (root->u.leaf.oblist == (olist *)NULL)
			emptynodes++;
		else {
			count = 0;
			for (obs = root->u.leaf.oblist; obs != (olist *)NULL; obs = obs->nxt)
				count++;
			numobjptrs += count;
			if (mininleaf > count)
				mininleaf = count;
			if (maxinleaf < count)
				maxinleaf = count;
			totleafs++;
		}
	} else {
		getstats(root->u.branch.left);
		getstats(root->u.branch.right);
	}
}
#endif

#ifdef TIME_STATS
/*
 * printtime
 *
 *      print out how much time has been taken up.
 */
printtime(s)
	char    *s;
{
	float           diff;
	time_t          now, real;
	char            buf[BUFSIZ];

	times(&buffer);

	diff = buffer.tms_utime + buffer.tms_stime - start_time;

	sprintf(buf, "%s %.2f seconds.\n", s, diff / 60.0);       
	message(buf);
}

#endif

#ifdef PC
/****
 * Handle user abort requests.
 **/

void 	ctrl_C()
{
	signal(SIGINT, SIG_IGN);	/* ignore any abort requests in this routine */
	uninit_tiles();
	exit(1);
}
#endif
