#include <stdio.h>
#include <math.h>
#include <sys/types.h>

#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif

#include "art.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>

extern char    *rindex();

long            filetype = PIX_RLE;	/* output file format */

int             xsize, ysize;
int             linecount = 1;

FILE           *logfile = stdout;

char           *title;		/* title of picture */
colour          backcol = {0.0, 0.0, 0.0};


/* Linked list of hosts */
struct server {
	char            hostname[30];
	int             s;	/* socket # */
	int             work;	/* Is it doing computations? */
	struct server  *next;	/* next host ptr */
};
struct server  *root;		/* root of linked list */


/* Network variables */
struct hostent *hp;
struct servent *sp;
struct sockaddr_in us;
struct sockaddr_in them;
#define MY_PORT 4567

int             tmpdata;	/* file descriptor for temporary file */
char            tempfile[L_tmpnam];

main(ac, av)
	int             ac;
	char           *av[];
{
	int             y, y1, preprocess;
	char           *p, name[BUFSIZ], buf[BUFSIZ];
	FILE           *f;
	image          *im;
	unsigned char  *red, *green, *blue, *alpha;
	struct server  *curr;
	int             addrlen;
	int             count;

	if (ac < 4)
		printf("usage: dart fname xsize ysize\n");

	read_in_servers();

	preprocess = 0;
	if (ac >= 5 && !strcmp(av[4], "-n"))
		preprocess = 1;

	sp = getservbyname("art", "tcp");
	if (sp == NULL)
		printf("art/tcp not in /etc/services. Assuming port # = %d\n", MY_PORT);

	curr = root;
	while (curr != NULL) {
		memset((char *) &us, 0, sizeof(struct sockaddr_in));
		memset((char *) &them, 0, sizeof(struct sockaddr_in));

		them.sin_family = AF_INET;
		hp = gethostbyname(curr->hostname);
		if (hp == NULL) {
			fprintf(stderr, "%s not found.\n", curr->hostname);
			exit(1);
		}
		them.sin_addr.s_addr = ((struct in_addr *) (hp->h_addr))->s_addr;

		if (sp == NULL)
			them.sin_port = MY_PORT;
		else
			them.sin_port = sp->s_port;

		curr->s = socket(AF_INET, SOCK_STREAM, 0);
		if (curr->s == -1) {
			perror("dart");
			printf("Unable to create socket.\n");
			exit(1);
		}
		if (connect(curr->s, &them, sizeof(struct sockaddr_in)) == -1) {
			perror("dart");
			printf("Unable to connect.\n");
			exit(1);
		}
		addrlen = sizeof(struct sockaddr_in);
		if (getsockname(curr->s, &us, &addrlen) == -1) {
			perror("dart");
			printf("Unable to read socket address.\n");
			exit(1);
		}
		printf("Connected to %s on port %u.\n", curr->hostname, ntohs(us.sin_port));

		curr = curr->next;
	}

	tmpnam(tempfile);
	tmpdata = creat(tempfile, 0666);
	if (tmpdata == -1) {
		perror("dart");
		printf("Cannot open tempfile.\n");
		exit(1);
	}
	CreateTemporaryFile();

	strcpy(name, av[1]);
	strcpy(rindex(name, '.'), PIX_SUFFIX);

	xsize = (unsigned short) atoi(av[2]);
	ysize = (unsigned short) atoi(av[3]);

	if ((im = openimage(name, "w")) == (image *) NULL) {
		printf("art: unable to open %s for writing\n", name);
		exit(1);
	}
	imagetype(im) = filetype;

	imagewidth(im) = xsize;
	imageheight(im) = ysize;

	imagedepth(im) = 24;

	imagedate(im) = time((time_t *) NULL);

	imagebackgnd(im).r = backcol.r * 255.0;
	imagebackgnd(im).g = backcol.g * 255.0;
	imagebackgnd(im).b = backcol.b * 255.0;

	if (title == (char *) NULL)
		titlelength(im) = 0;
	else {
		titlelength(im) = strlen(title) + 1;
		imagetitle(im) = title;
	}

	writeheader(im);

	red = (unsigned char *) malloc(xsize);
	green = (unsigned char *) malloc(xsize);
	blue = (unsigned char *) malloc(xsize);

	curr = root;
	while (curr != NULL) {
		strcpy(buf, av[1]);
		send(curr->s, buf, 15, 0);
		send(curr->s, &xsize, sizeof(int), 0);
		send(curr->s, &ysize, sizeof(int), 0);
		send(curr->s, &preprocess, sizeof(int), 0);
		curr = curr->next;
	}

	y = ysize - 1;
	while (y >= 0) {
		printf("%d\n", y);
		curr = root;
		while (curr != NULL) {
			if (curr->work == 1) {
				count = recv(curr->s, &y1, sizeof(int), MSG_PEEK);
				if (count == sizeof(int)) {
#ifdef DEBUG
					printf("%s is done ", curr->hostname);
#endif
					getdata(curr->s, &y1, sizeof(int));
					getdata(curr->s, red, xsize);
					getdata(curr->s, green, xsize);
					getdata(curr->s, blue, xsize);
#ifdef DEBUG
					printf("Line=%d\n", y1);
#endif
					writeline(ysize - y1 - 1, red, green, blue);
					curr->work = 0;
					if (y >= 0) {
						send(curr->s, &y, sizeof(int), 0);
						y--;
						curr->work = 1;
#ifdef DEBUG
						printf("Assigning %s Line %d\n", curr->hostname, y);
#endif
					}
				}	/* if count == 5 */
			}
			 /* if curr->work == 1 */ 
			else {	/* curr->work != 1 */
				if (y >= 0) {
					send(curr->s, &y, sizeof(int), 0);
					y--;
					curr->work = 1;
#ifdef DEBUG
					printf("ASSIGNING %s Line %d\n", curr->hostname, y);
#endif
				}
			}
			curr = curr->next;
		}
	}

	curr = root;
	while (curr != NULL) {
		if (curr->work == 1) {
			getdata(curr->s, &y1, sizeof(int));
			getdata(curr->s, red, xsize);
			getdata(curr->s, green, xsize);
			getdata(curr->s, blue, xsize);
			writeline(ysize - y1 - 1, red, green, blue);
			curr->work = 0;
		}
		y = -9;
		send(curr->s, &y, sizeof(int), 0);
		curr = curr->next;
	}

	close(tmpdata);

	tmpdata = open(tempfile, O_RDONLY, 0);
	if (tmpdata == -1) {
		perror("dart");
		printf("Cannot open tempfile.\n");
		exit(1);
	}
	for (y = 0; y < ysize; y++) {
		readline(y, red, green, blue);
		writergbline(im, red, green, blue);
	}
	closeimage(im);

	unlink(tempfile);
	exit(0);
}

read_in_servers()
{
	FILE           *fp;
	char            host[30];
	struct server  *tmp;
	int             i;

	root = NULL;
	fp = fopen("servers.art", "r");
	if (fp == NULL)
		printf("Cannot open servers.art");

	while (!feof(fp)) {
		i = fscanf(fp, "%s", host);
		if (host[0] != NULL && i != EOF && i == 1) {
			tmp = (struct server *) malloc(sizeof(struct server));
			strcpy(tmp->hostname, host);
			tmp->work = 0;
			tmp->next = root;
			root = tmp;
		}
	}

	tmp = root;
	i = 0;
	while (tmp != NULL) {
		printf("Server %d = %s\n", i, tmp->hostname);
		i++;
		tmp = tmp->next;
	}
}

CreateTemporaryFile()
{
	unsigned char  *tmp;
	int             y;

	tmp = (unsigned char *) malloc(xsize * 3L);
	if (tmp == NULL) {
		printf("Memory allocation failure.\n");
		exit(1);
	}
	memset(tmp, 0, xsize * 3L);
	for (y = 0; y <= ysize; y++)
		write(tmpdata, tmp, xsize * 3L);
	free(tmp);
}

writeline(y, r, g, b)
	int             y;
	unsigned char  *r, *g, *b;
{
	lseek(tmpdata, y * xsize * 3L, SEEK_SET);
	write(tmpdata, r, xsize);
	write(tmpdata, g, xsize);
	write(tmpdata, b, xsize);
}

readline(y, r, g, b)
	int             y;
	unsigned char  *r, *g, *b;
{
	lseek(tmpdata, y * xsize * 3L, SEEK_SET);
	read(tmpdata, r, xsize);
	read(tmpdata, g, xsize);
	read(tmpdata, b, xsize);
}

getdata(s, buf, n)
	int             s;
	unsigned char  *buf;
	int             n;
{
	int             j, k;

	j = recv(s, buf, n, 0);
	while (j < n) {
		k = recv(s, &buf[j], n - j, 0);
		if (k == -1) {
			printf("Socket recv error.\n");
			exit(1);
		}
		j += k;
	}
}
