#include <math.h>
#include <stdio.h>
#include "art.h"
#include "objs.h"
#include "macro.h"
#include "gram.h"

extern mats	*mstackp;
extern attr	*astackp;

extern hlist	*fhlist;
extern int 	linecount;
extern float	tolerance;
extern int	lookatdone;

/*
 * polygoninit
 *
 *	initialise the function pointers and fields for a polygon
 */
void
polygoninit(o, d)
	object	*o;
	details *d;
{
	polygon		*pg;
	int		axis, i, count, ccount, ncount, dcount;
	matrix		m, tmp;
	vector		v, v1, v2, ovt[ART_MAXVERTS], vt[ART_MAXVERTS], norms[4];
	vector		xv, yv, zv;
	float		maxx, maxy, maxz, minx, miny, minz;
	float		vx, vz, radius, area, tolerance;
	vector		colours[4], on;
	char		buf[MESLEN];
	details		*ld, *d1, *ld1, *headd;

	count = 0;

	if (!lookatdone)
		deflookat();

	while (d != (details *)NULL) {
		switch (d->type) {
		case VERTEX:
					/* transform vertex into ray space */
			ovt[count] = d->u.v;
			/*
			vmmult(vt[count], d->u.v, mstackp->obj2ray);
			*/
			count++;
			break;
		case COMPLEXVERTEX:
			if (ccount == 4 || ncount == 4)
				fatal("art: can't interpolate across a polygon with more than 4 vertices.\n");

			dcount = 0;
			for (d1 = d->u.det; d1 != (details *)NULL; d1 = d1->nxt)
				dcount++;
				
			for (d1 = d->u.det; d1 != (details *)NULL; d1 = ld1) {
				if (d1->type == VERTEX) {
					if (dcount > 1) {	/* actual vertex will be last in list */
						norms[ncount] = d1->u.v;
						normalise(norms[ncount]);
						ncount++;
					} else {
						ovt[count] = d1->u.v;
						vmmult(vt[count], d1->u.v, mstackp->obj2ray);
					}
				} else {
					colours[ccount] = d1->u.v;
					ccount++;
				}
				dcount--;
				ld1 = d1->nxt;
				free(d1);
			}

			count++;
			break;
		default:
			warning("art: illegal field in polygon ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	vsub(v1, ovt[1], ovt[0]);
	vsub(v2, ovt[2], ovt[1]);

	xprod(on, v1, v2);

	if (on.x == 0.0 && on.y == 0.0 && on.z == 0.0) {
		sprintf(buf, "invalid polygon in file before line %d\n", linecount);
		warning(buf);
		o->type = NULL_OBJ;

		return;
	} else {
		pushmatrix();
			calctransforms(mstackp);
			multmatrix(mstackp->obj2ray);

			move(ovt[count - 1].x, ovt[count - 1].y, ovt[count - 1].z);

			for (i = 0; i != count; i++)
				draw(ovt[i].x, ovt[i].y, ovt[i].z);
		popmatrix();
	}
}
