/**************************************************************************
*                sxbm.c                                                   *
*                                                                         *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.       *
*                                                                         *
*  This module contains the code to save the XBM file format.             *
*                                                                         *
**************************************************************************/
/* 110395 -HT- Works with Mapper, but not with XV.    *
*  120395 -HT- Now it works fine, also with XV.       *
*  160595 -HT- Makefile support.                      *
*/

#include <math.h>
#include <stdio.h>
#include "image.h"

Save_XBM_Image( Image, name )
struct Image_Struct *Image;
char *name;
{
  unsigned int Width, Height;
  unsigned char *data;
  int x, y, i, column=0;
  FILE *out;
  char compl[2];

  Width = Image->width;
  Height = Image->height;

  if( (data=(unsigned char *)malloc( Height*(int)ceil((float)Width/8.0)*sizeof(unsigned char) ))==NULL ) {
    printf("Failed to allocate memory for bitmap data.\n");
    Close();
    }
  for( y=0; y<Height; y++ )
    for( x=0; x<(int)ceil((float)Width/8.0); x++ )
      data[y*(int)ceil((float)Width/8.0)+x]=0;

  for( y=0; y<Height; y++ )
    for( x=0; x<(int)ceil((float)Width/8.0); x++ )
      for( i=0; i<8; i++ )
        if( Image->data.map_lines[y][x*8+i] )
          data[y*(int)ceil((float)Width/8.0)+x]=
            data[y*(int)ceil((float)Width/8.0)+x]|1<<i;

  if( (out=fopen( name, "w" ))==NULL ) {
    printf("Can NOT open file %s for writing.\n",name);
    Close();
    }

  fprintf(out, "#define %s_width %d\n", name, Width );
  fprintf(out, "#define %s_height %d\n", name, Height );
  fprintf(out, "static unsigned char %s_bits[] = {\n", name );
  fprintf(out, "   ");

  for( y=0; y<Height; y++ )
    for( x=0; x<(int)ceil((float)Width/8.0); x++ )
      {
      if( data[y*(int)ceil((float)Width/8.0)+x]>15 )
        compl[0]=0;
      else
        compl[0]='0';
      fprintf(out, "0x%s%x, ",compl, data[y*(int)ceil((float)Width/8.0)+x] );
      if( ++column==12 )
        {
        column=0;
        fprintf(out, "\n   ");
        }
     }
  fprintf(out, "};\n");


  fclose( out );
  free( data );
}
