/*********************************************************************
*                  question.c                                        *
*                                                                    *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.  *
*                                                                    *
*  This module contains code to ask simple True/False questions      *
*  in the window.                                                    *
*                                                                    *
* 040495 -HT- Works.                                                 *
* 160595 -HT- Makefile support.                                      *
*********************************************************************/

#include <math.h>
#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

Question( msg1, msg2, msg3, msg4, msg5 )
char *msg1, *msg2, *msg3, *msg4, *msg5;
{
  XWindowAttributes theAttributes;
  short offx, offy;
  char fresh=0;

  XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
  if( theAttributes.width<260 || theAttributes.height<130 )
    {
    printf("Too small window! Cannot create requester.\n");
    return(1);
    }

  offx = (int)((float)theAttributes.width/2.0)-125;
  offy = (int)((float)theAttributes.height/2.0)-60;

  storage_block_xi = XGetImage(theDisplay, theWindow, offx, offy,
                               250+1, 120+1, 255, ZPixmap);

  XClearArea( theDisplay, theWindow, offx, offy, 250, 120, False );
  XFlush(theDisplay);

  Draw_Question( msg1, msg2, msg3, msg4, msg5, offx, offy );

  while(1)
    {
    XNextEvent( theDisplay, &theEvent );

    switch( theEvent.type )
      {
      case Expose:
        Draw_Question( msg1, msg2, msg3, msg4, msg5, offx, offy );
        fresh=2;
        break;
      case ConfigureNotify:
        XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
        if( theAttributes.width<260 || theAttributes.height<130 )
          {
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 250+1, 120+1 );
          return( 1|fresh );
          }
        break;
      case KeyPress:
        if( theEvent.xkey.keycode==36 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 250+1, 120+1 );
          return( 0|fresh );
          }
        if( theEvent.xkey.keycode==9 )
          {
          printf("Cancel\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 250+1, 120+1 );
          return( 1|fresh );
          }
        break;
      case ButtonPress:
        if( theEvent.xbutton.x>offx+20 && theEvent.xbutton.x<offx+115 &&
            theEvent.xbutton.y>offy+85 && theEvent.xbutton.y<offy+105 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 250+1, 120+1 );
          return( 0|fresh );
          }
        if( theEvent.xbutton.x>offx+135 && theEvent.xbutton.x<offx+230 &&
            theEvent.xbutton.y>offy+85 && theEvent.xbutton.y<offy+105 )
          {
          printf("Cancel\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 250+1, 120+1 );
          return( 1|fresh );
          }
        break;
      }
    }
}

Draw_Question( msg1, msg2, msg3, msg4, msg5, offx, offy )
char *msg1, *msg2, *msg3, *msg4, *msg5;
short offx, offy;
{
  short btx;

  XSetForeground( theDisplay, theGC, theBlackPixel );
  XDrawRectangle( theDisplay, theWindow, theGC, offx, offy, 250, 120 );
  XDrawRectangle( theDisplay, theWindow, theGC, offx+20, offy+85, 95, 20 );
  XDrawRectangle( theDisplay, theWindow, theGC, offx+135, offy+85, 95, 20 );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+20, msg1, 
strlen(msg1) );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+40, msg2, 
strlen(msg2) );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+60, msg3, 
strlen(msg3) );
  btx = offx+70-(int)((float)strlen(msg4)/2.0)*7;
  XDrawString( theDisplay, theWindow, theGC, btx, offy+100, msg4, 
strlen(msg4) );
  btx = offx+185-(int)((float)strlen(msg5)/2.0)*7;
  XDrawString( theDisplay, theWindow, theGC, btx, offy+100, msg5, 
strlen(msg5) );
  XFlush(theDisplay);
}

