/*********************************************************************
*                      misc.c                                        *
*                                                                    *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.  *
*                                                                    *
*  170495 -HT- AddToString();                                        *
*  190495 -HT- ConvertNroToString() works.                           *
*  110595 -HT- ConvertNroToString() supports also negative           *
*              values now.                                           *
*  160595 -HT- Makefile support.                                     *
*********************************************************************/

#include <math.h>
#define True 1
#define False 0

/*  AddToString is an excellent tool for constructing complex ascii strings. */
/*  170495 (c) Hessu.                                                        */
AddToString( text, add )
char *text, *add;
{
  unsigned char l, pntr=0;

  for( l=strlen(text); l<strlen(text)+strlen(add); l++ )
    {
    text[l] = add[pntr];
    pntr++;
    }
}

ConvertNroToString( nro, string, wdth )
int nro, wdth;
char *string;
{
  char strg[6];
  unsigned char n=0, m=0, neg=False;

  if( nro<0 )
    {
    neg = True;
    nro = -nro;
    }

  if( nro>=100000 )
    {
    strg[0] = (int)( (float)nro / 100000.0 ) + 48;
    while( nro >= 100000 )
      nro -= 100000;
    }
  else
    strg[0] = 32;
  if( nro>=10000 )
    {
    strg[1] = (int)( (float)nro / 10000.0 ) + 48;
    while( nro >= 10000 )
      nro -= 10000;
    }
  else
    if( strg[0]==32 ) strg[1] = 32;
    else strg[1] = 48;
  if( nro>=1000 )
    {
    strg[2] = (int)( (float)nro / 1000.0 ) + 48;
    while( nro >= 1000 )
      nro -= 1000;
    }
  else
    if( strg[1]==32 ) strg[2] = 32;
    else strg[2] = 48;
  if( nro>=100 )
    {
    strg[3] = (int)( (float)nro / 100.0 ) + 48;
    while( nro >= 100 )
      nro -= 100;
    }
  else
    if( strg[2]==32 ) strg[3] = 32;
    else strg[3] = 48;
  if( nro>=10 )
    {
    strg[4] = (int)( (float)nro / 10.0 ) + 48;
    while( nro >= 10 )
      nro -= 10;
    }
  else
    if( strg[3]==32 ) strg[4] = 32;
    else strg[4] = 48;
  strg[5] = nro+48;

  if( wdth>0 )
    {
    if( neg )
      {
      string[m] = '-';
      m++;
      }
    for( n=0; n<wdth; n++ )
      {  
      string[m] = strg[6-wdth+n];
      m++;
      }
    string[m] = 0;
    }
  else
    {
    while( strg[n]==32 ) n++;
    if( neg )
      {
      string[m] = '-';
      m++;
      }
    for( ; n<6; n++ ) {
      string[m] = strg[n];
      m++;
      }
    string[m] = 0;
    }
}
