/*+-----------------------------------------------------------------------+
 *| This header file is for use with the 'C' source module 'tessel.c'.    |
 *|                                                                       |
 *| Author: Michael S. A. Robb         Version: 1.1        Date: 29/05/93 |
 *+-----------------------------------------------------------------------+
 */

#define CONSTANT_ONE   0x10000L
typedef long MATDATA;

/*+-----------------------------------------------------------------------+
 *| Function prototypes.                                                  |
 *+-----------------------------------------------------------------------+
 */

void polygon_tesselate(            int nverts, COORD *vlist );
void polygon_tesselate_convex(     int nverts, COORD *vlist );
void polygon_tesselate_concave(    int nverts, COORD *vlist );
void polygon_tesselate_complex(    int nverts, COORD *vlist );
void polygon_tesselate_noncomplex( int nverts, COORD *vlist );

int  polygon_clockwise(            int nverts, COORD *vlist );
void polygon_reverse(              int nverts, COORD *vlist );
int  polygon_convex(               int nverts, COORD *vlist );
int  polygon_complex(              int nverts, COORD *vlist );

void polygon_setproc(           void (*polygon_proc)( COORD *triangle ) );

/*+-----------------------------------------------------------------------+
 *| Some useful macros for angle/polygon/coordinate/triangle tests.       |
 *+-----------------------------------------------------------------------+
 */

#define MATRIX_DET_2X2( C1, C2, C3, C4 )\
          ( ( (MATDATA) (C2).c_xpos - (MATDATA) (C1).c_xpos )\
          * ( (MATDATA) (C4).c_ypos - (MATDATA) (C3).c_ypos )\
          - ( (MATDATA) (C4).c_xpos - (MATDATA) (C3).c_xpos )\
          * ( (MATDATA) (C2).c_ypos - (MATDATA) (C1).c_ypos ))

#define COORD_ANGLE( VL, C1, C2, C3 )\
            MATRIX_DET_2X2( VL[C3], VL[C1], VL[C2], VL[C1] )

#define ANGLE_NONCONVEX( VL, C1, C2, C3 )\
            ( COORD_ANGLE( VL, C1, C2, C3 ) >= 0 )

#define ANGLE_CONVEX( VL, C1, C2, C3 )\
            ( COORD_ANGLE( VL, C1, C2, C3 ) < 0 )

#define COORD_OUTSIDE_TRIANGLE( VL, T1, T2, T3, C )\
          ( MATRIX_DET_2X2( VL[T2], VL[T1], VL[C], VL[T1] )< 0 ||\
            MATRIX_DET_2X2( VL[T3], VL[T2], VL[C], VL[T2] )< 0 ||\
            MATRIX_DET_2X2( VL[T1], VL[T3], VL[C], VL[T3] )< 0 )

