/*+-----------------------------------------------------------------------+
 *| The following table defines the internal I/O registers contained      |
 *| within the TMS34010 microprocessor.                                   |
 *|                                                                       |
 *| Author: Michael S. A. Robb         Version: 1.1        Date: 16/06/93 |
 *+-----------------------------------------------------------------------+
 */

#define IO_HESYNC      0xC0000000L     /* Horizontal End     Sync  */
#define IO_HEBLNK      0xC0000010L     /* Horizontal End     Blank */
#define IO_HSBLNK      0xC0000020L     /* Horizontal Start   Blank */
#define IO_HTOTAL      0xC0000030L     /* Horizontal Total         */
#define IO_VESYNC      0xC0000040L     /* Vertical   End     Sync  */
#define IO_VEBLNK      0xC0000050L     /* Vertical   End     Blank */
#define IO_VSBLNK      0xC0000060L     /* Vertical   Start   Blank */
#define IO_VTOTAL      0xC0000070L     /* Video      Total         */
#define IO_DPYCTL      0xC0000080L     /* Display    Control       */
#define IO_DPYSTRT     0xC0000090L     /* Display    Start         */
#define IO_DPYINT      0xC00000A0L     /* Display    Interrupt     */
#define IO_CONTROL     0xC00000B0L     /* Control                  */
#define IO_HSTDATA     0xC00000C0L     /* Host       Data          */
#define IO_HSTADRL     0xC00000D0L     /* Host       Address Low   */
#define IO_HSTADRH     0xC00000E0L     /* Host       Address High  */
#define IO_HSTCTLL     0xC00000F0L     /* Host       Control Low   */
#define IO_HSTCTLH     0xC0000100L     /* Host       Control High  */
#define IO_INTENB      0xC0000110L     /* Interrupt  Enable        */
#define IO_INTPEND     0xC0000120L     /* Interrupt  Pending       */
#define IO_CONVSP      0xC0000130L     /* Conversion (Src. Pitch)  */
#define IO_CONVDP      0xC0000140L     /* Conversion (Dst. Pitch)  */
#define IO_PSIZE       0xC0000150L     /* Pixel      Size          */
#define IO_PMASK       0xC0000160L     /* Plane      Mask          */
#define IO_RESERVED1   0xC0000170L     /* Reserved                 */
#define IO_RESERVED2   0xC0000180L     /* Reserved                 */
#define IO_RESERVED3   0xC0000190L     /* Reserved                 */
#define IO_RESERVED4   0xC00001A0L     /* Reserved                 */
#define IO_DPYTAP      0xC00001B0L     /* Display    Tap Point     */
#define IO_HCOUNT      0xC00001C0L     /* Horizontal Count         */
#define IO_VCOUNT      0xC00001D0L     /* Vertical   Count         */
#define IO_DPYADR      0xC00001E0L     /* Display    Address       */
#define IO_REFCNT      0xC00001F0L     /* DRAM       Refresh Count */

/*+-----------------------------------------------------------------------+
 *| The following table defines other external I/O registers accessible   |
 *| via the TMS34010 microprocessor bus.                                  |
 *+-----------------------------------------------------------------------+
 */

#define RAMDAC_WRITE   0x06000000L     /* Write address for data.  */
#define RAMDAC_DATA    0x06000010L     /* Data address.            */
#define RAMDAC_COMMAND 0x06000020L     /* Command address.         */
#define RAMDAC_READ    0x06000030L     /* Read address for data.   */

/*+-----------------------------------------------------------------------+
 *| The following constants define the read and write addresses for the   |
 *| CONFIGURATION 1 REGISTER.                                             |
 *|                                                                       |
 *|  15 14 13 12 11 10  9  8  7  6  5  4   3  2  1  0                     |
 *| +-----------------------------------+---+--------+                    |
 *| |  RESERVED                         |RS2|  VCLK  |                    |
 *| +-----------------------------------+---+--------+                    |
 *|                                                                       |
 *| Bits 0-2  - Selects the clock frequency for the screen refresh.       |
 *|             See CLOCK_ENUM.                                           |
 *|                                                                       |
 *| Bit    3  - Controls access to overlay and command access.            |
 *|             See ACCESS_ENUM.                                          |
 *|                                                                       |
 *| Bits 4-15 - Not Used.                                                 |
 *+-----------------------------------------------------------------------+
 */

#define CONFIG1_WRITE  0x060000C0L     /* External timing write.   */
#define CONFIG1_READ   0x060001C0L     /* Default configuration.   */

/*+-----------------------------------------------------------------------+
 *| The following constants define the read and write addresses for the   |
 *| CONFIGURATION 2 REGISTER.                                             |
 *|                                                                       |
 *|  15 14 13 12 11 10  9  8  7  6  5    4     3    2  1  0               |
 *| +--------------------------------+----+-----+-----+----+              |
 *| |  RESERVED                      |HINT|VSYNC|HSYNC|PSEL|              |
 *| +--------------------------------+----+-----+-----+----+              |
 *|                                                                       |
 *| Bits 0-1  - 00 = VGA Control Video RAM                                |
 *|             01 = 32 bits per pixel                                    |
 *|             10 = 16 bits per pixel                                    |
 *|             11 =  8 bits per pixel                                    |
 *|                                                                       |
 *| Bit    2  - Horizontal sync: 0 = Positive, 1 = Negative.              |
 *|                                                                       |
 *| Bit    3  - Vertical   sync: 0 = Positive, 1 = Negative.              |
 *|                                                                       |
 *| Bit    4  - Host interrupts: 0 = Disabled, 1 = Enabled.               |
 *|                                                                       |
 *| Bits 5-15 - Not used.                                                 |
 *+-----------------------------------------------------------------------+
 */

#define CONFIG2_WRITE  0x060000E0L     /* Display Pitch.           */
#define CONFIG2_READ   0x060001E0L

/*+-----------------------------------------------------------------------+
 *| The following table defines the TMS34010 registers which may be       |
 *| accessed via the main CPU's data bus ie. the 80x86.                   |
 *+-----------------------------------------------------------------------+
 */

#define CPU_ADDRLO     0xC0007E00L     /* Host Address Low  Word   */
#define CPU_ADDRHI     0xC0007F00L     /* Host Address High Word   */
#define CPU_CONTROL    0xC0007D00L     /* Host Control             */
#define CPU_SLOWDATA   0xC0007000L     /* Host Data Registers      */
#define CPU_FASTDATA   0xA0000000L     /* Host Data Registers      */

#define HOST_AUTOINCR       0xD800     /* Automatic increments.    */
#define HOST_NOINCR         0xC000     /* No increments.           */

/*+-----------------------------------------------------------------------+
 *| The following constants define the various clock speeds that may be   |
 *| used to drive the video monitor.                                      |
 *|                                                                       |
 *| Stored in the 'tms_clockbase' field of the TMS34010_MODE structure.   |
 *+-----------------------------------------------------------------------+
 */

#define CLOCK_14280MHZ      0x00       /* 14.280MHz ???  pixels ?? */
#define CLOCK_20000MHZ      0x01       /* 20.000MHz 512  pixels 24 */
#define CLOCK_VGA           0x02       /* Current VGA Clock        */
#define CLOCK_36000MHZ      0x03       /* 36.000MHz 800  pixels  8 */
#define CLOCK_44900MHZ      0x04       /* 44.900MHz 1024 pixels I8 */
#define CLOCK_64000MHZ      0x05       /* 64.000MHz 1024 pixels U8 */
#define CLOCK_25175MHZ      0x06       /* 25.175MHz 640  pixels 16 */
#define CLOCK_50350MHZ      0x07       /* 50.350MHz 640  pixels  8 */

/*+-----------------------------------------------------------------------+
 *| The following constants define the format of the current video mode.  |
 *+-----------------------------------------------------------------------+
 */

#define VSCAN_INTERLACED    0x00       /* Interlaced scan.         */
#define VSCAN_UNINTERLACED  0x0C       /* Uninterlaced scan.       */

/*+-----------------------------------------------------------------------+
 *| The following constants are used to select the size of pixels in the  |
 *| current video mode.                                                   |
 *+-----------------------------------------------------------------------+
 */

#define PIXEL_SIZE8         0x03       /* Pixel depth -  8 bits.   */
#define PIXEL_SIZE16        0x02       /* Pixel depth - 16 bits.   */
#define PIXEL_SIZE32        0x01       /* Pixel depth - 32 bits.   */

/*+-----------------------------------------------------------------------+
 *| The following constants are used to select the format of the overlay  |
 *| option.                                                               |
 *+-----------------------------------------------------------------------+
 */

#define OVERLAY_4BITS       0x00       /* 4-bit overlay.           */
#define OVERLAY_1BIT        0x02       /* 1-bit overlay.           */
#define OVERLAY_NONE        0x03       /* No    overlay.           */

/*+-----------------------------------------------------------------------+
 *| The following bit-masks are used with the Display Control register    |
 *| DPYCTL.                                                               |
 *+-----------------------------------------------------------------------+
 */

#define HC_ENV              0x8000     /* Enable video.               */
#define HC_NIL              0x4000     /* Noninterlaced video enable. */
#define HC_DXV              0x2000     /* Disable external video.     */
#define HC_SRE              0x1000     /* Screen refresh enable.      */
#define HC_SRT              0x0800     /* Shift register enable.      */
#define HC_ORG              0x0400     /* Screen origin select.       */
#define HC_HSD              0x0001     /* Horizontal sync direction.  */

/*+-----------------------------------------------------------------------+
 *| These values are used to select the display pitch for the VRAM shift  |
 *| registers.                                                            |
 *+-----------------------------------------------------------------------+
 */

#define HC_DUDATE0          0x0000     /* Number of bytes per line.   */
#define HC_DUDATE1          0x0004
#define HC_DUDATE2          0x0008
#define HC_DUDATE4          0x0010     /*  512 bytes per line.        */
#define HC_DUDATE8          0x0020     /* 1024 bytes per line.        */
#define HC_DUDATE16         0x0040     /* 2048 bytes per line.        */
#define HC_DUDATE32         0x0080
#define HC_DUDATE64         0x0100
#define HC_DUDATE128        0x0200

/*+-----------------------------------------------------------------------+
 *| These values are specific to the Hercules Graphics Station Card.      |
 *+-----------------------------------------------------------------------+
 */

#define MODE_UNINTERLACED    (HC_ENV|HC_DXV|HC_SRE|HC_NIL)
#define MODE_INTERLACED      (HC_ENV|HC_DXV|HC_SRE)
#define MODE_4KBYTE           HC_DUDATE32
#define MODE_2KBYTE           HC_DUDATE16
#define MODE_1KBYTE           HC_DUDATE8
#define MODE_512BYTES         HC_DUDATE4

/*+-----------------------------------------------------------------------+
 *| The following table shows the organisation of the CLUT control bits.  |
 *|                                                                       |
 *|                 Bits 3-2                                              |
 *|                                                                       |
 *|                        00            01          10         11        |
 *|                  00    24/LU         24/NLU      NA         NA        |
 *|  Bits 7-6        01    24/LU         24/NLU      8G/LU      8G/NLU    |
 *|                  10    24/LU         24/NLU      NA         NA        |
 *|                  11    NA            NA          NA         16/NLU    |
 *|                                                                       |
 *+-----------------------------------------------------------------------+
 */

/*+-----------------------------------------------------------------------+
 *| The following constants are for use with the BrookTree 473 palette    |
 *| chip.                                                                 |
 *+-----------------------------------------------------------------------+
 */

#define MODE_24BIT_NOCLUT       0x34        /* 00xx01xx */
#define MODE_24BIT_CLUT         0x10        /* 00xx00xx */
#define MODE_16BIT              0xDC        /* 11xx11xx */
#define MODE_8BIT_NOCLUT        0x5C        /* 01xx11xx */
#define MODE_8BIT_CLUT          0x58        /* 01xx10xx */

#define DEFAULT_8BIT            (MODE_8BIT_CLUT    | OVERLAY_NONE)
#define DEFAULT_16BIT           (MODE_16BIT        | OVERLAY_NONE)
#define DEFAULT_24BIT           (MODE_24BIT_NOCLUT | OVERLAY_NONE)

