#ifndef swShader_VertexPipeline_hpp
#define swShader_VertexPipeline_hpp

#include "VS_2_0Assembler.hpp"

namespace swShader
{
	class VertexPipeline : public VS_2_0Assembler
	{
	public:
		VertexPipeline();

		~VertexPipeline();

		void loadConstants();

		static void setTransform(const Matrix &M);
		static void setCameraPosition(const Point &P);

		// Light properties
		static void setAmbientLight(const Color<float> &ambientLight);
		static void setLightPosition(int light, const Point &P);
		static void setLightColor(int light, const Color<float> &lightColor);
		static void setLightAttenuation(int light, float constant, float linear, float quadratic);
		static void setLightRange(int light, float lightRange);

		static void resetLights();   // Disable all lights

		// Material properties
		static void setMaterialEmission(const Color<float> &emission);
		static void setMaterialAmbient(const Color<float> &materialAmbient);
		static void setMaterialDiffuse(const Color<float> &diffuseColor);
		static void setMaterialSpecular(const Color<float> &specularColor);
		static void setMaterialShininess(const float specularPower[4]);

	private:
		void encode();
		void pipeline();

		void *reference(const Operand &reg);

		static bool lightEnable[8];

		static float4 constant[256];
		static float4 transform[4];
		static float4 cameraPosition;
		static float4 lightPosition[8];
		static float4 lightColor[8];
		static float4 attenuationConstant[8];
		static float4 attenuationLinear[8];
		static float4 attenuationQuadratic[8];
		static float4 lightRange[8];
		static float4 ambientLight;
		static float4 materialEmission;
		static float4 materialAmbient;
		static float4 materialDiffuse;
		static float4 materialSpecular;
		static float4 materialShininess;

		static Operand zero;
		static Operand one;

		static Operand trans;	// Transform
		static Operand light0;	// Light position
		static Operand pow;		// Specular power
		static Operand cam;		// Camera position in model space
		static Operand amb;		// Ambient light
		static Operand spec;	// Specular material color
		static Operand emiss;	// Emissive material light
		static Operand mamb;	// Ambient material color
		static Operand diff;	// Diffuse material color
		static Operand lcol0;	// Light color
		static Operand att0c;	// Attenuation constant factor
		static Operand att0l;	// Attenuation linear factor
		static Operand att0q;	// Attenuation quadratic factor
		static Operand range;	// Light range

		static Operand v0;
		static Operand v1;
		static Operand v2;

		static Operand r0;
		static Operand r1;
		static Operand r2;
		static Operand r3;
		static Operand r4;
		static Operand r5;
		static Operand r6;
		static Operand r7;

		static Operand oPos;
		static Operand oT0;
		static Operand oT1;
		static Operand oD0;
		static Operand oD1;
	};
};

#endif   // swShader_VertexPipeline_hpp