/* parse.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <math.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry.h>

/* reads script to display and optionally reocrd sequence(s) of frame(s) from
   Anima file(s) on a server */

/* find_total_frames:  find number of frames left to record */

main (argc,argv)

int argc ;
char *argv[] ;

{
    FILE *in ;				/* Anima file */
    int place_holder ;		/* keeps place in file when need to
					   scan ahead */
    char line[80] ;			/* line in script */
    char command[80] ;			/* script command */
    char server[80] ;			/* symbolic name for server */
    int prognum = S_PCPROG ;		/* RPC program number */
    int seconds_to_hold = 0 ;
    int search_frame = 0 ;		/* frame to search to */
    int playto_frame = 0 ;		/* frame to play to */
    char mode[80] ;
    int speed = 1 ;			/* playback speed */
    int rec_mode = S_PREVIEW ;		/* preview or record */
    int frames_remaining ;		/* number of frames left to record */
    int i ;

    if ((in = fopen (argv[1],"r")) == NULL)
    {
	fprintf (stderr,"no such script file\n");
	exit(0) ;
    }
    if (argc == 3)
        rec_mode = atoi(argv[2]) ;
    server[0] = NULL ;
    S_image_info.c_height = 0 ;
    S_image_info.c_width = 0 ;
	/* starting an Anima sequence */
    S_avars.start = 1 ;
    while ((fgets(line,80,in)) != NULL)
    {
        if ((strncmp("connect",line,7)) == 0)
	{
		/* only one connection allowed at a time */
	    if (server[0] != NULL)
		scry_close() ;
	    sscanf (line,"%s %s %d",command,server,&prognum) ;
	    fprintf (stderr,"%s %s %d\n",command,server,prognum) ;
		/* establish a connection with the server */
	    if (!scry_connect(server,prognum))
	    {
		fprintf (stderr,"unable to connect to server\n") ;
		exit(0) ;
	    }
		/* if in recording mode */
	    if (rec_mode != S_PREVIEW)
	    {
		place_holder = ftell(in) ;
		    /* find number of frames left to record */
		find_total_frames(in,&frames_remaining) ;
		fseek(in,place_holder,0) ;
	    }
	    else
		frames_remaining = 1 ;
                /* initialize the recorder */
	    scry_init_record(rec_mode,frames_remaining) ;
		/* get server display information */
	    sc_get_info() ;
	}
        else if ((strncmp("get",line,3)) == 0)
	{
	    sscanf (line,"%s %s",command,S_anima_filename) ;
	    fprintf (stderr,"%s %s\n",command,S_anima_filename) ;
		/* read in the Anima footer */
	    if (!getfile())
	    {
		fprintf (stderr,"%s does not exist\n",S_anima_filename);
		scry_close() ;
		exit(0) ;
	    }
	}
        else if ((strncmp("blank",line,5)) == 0)
	{
	    sscanf (line,"%s",command) ;
	    fprintf (stderr,"%s\n",command) ;
		/* blank the server */
	    clear_server_display() ;
	}
        else if ((strncmp("hold",line,4)) == 0)
	{
		/* noop */
	    sscanf (line,"%s %d",command,&seconds_to_hold) ;
	    fprintf (stderr,"%s %d\n",command,seconds_to_hold) ;
	}
        else if ((strncmp("search",line,6)) == 0)
	{
		/* search to given frame in Anima file */
	    sscanf (line,"%s %d",command,&search_frame) ;
	    if ((search_frame < 0) || (search_frame > S_anima_count))
	    {
		fprintf (stderr,"illegal search frame: %d\n",search_frame) ;
		scry_close() ;
		exit(0) ;
	    }
	    fprintf (stderr,"%s %d\n",command,search_frame) ;
		    /* transmit, display, and optionally record on server */
	    display_frame(search_frame) ;
	}
        else if ((strncmp("playto",line,6)) == 0)
	{
	    sscanf (line,"%s %d %s %d",command,&playto_frame,
				       mode,&speed) ;
	    if ((playto_frame < 0) || (playto_frame > S_anima_count))
	    {
		fprintf (stderr,"illegal search frame: %d\n",playto_frame) ;
		scry_close();
		exit(0) ;
	    }
	    fprintf (stderr,"%s %d %s %d\n",command,playto_frame,mode,speed) ;
		/* play to given frame in Anima file, either forward
		   or reverse */
	    if (playto_frame >= search_frame)
	    {
	        for (i = search_frame+1 ; i <= playto_frame ; i++)
		    display_frame (i) ;
	    }
	    else
	    {
	        for (i = search_frame-1 ; i >= playto_frame ; i--)
		    display_frame (i) ;
	    }
	    search_frame = playto_frame ;
	}
    }
    fclose(in) ;
    scry_close() ;
}




/* find number of frames left to record */

find_total_frames(in,frames_remaining)

FILE *in ;
int *frames_remaining ;

{
    char line[80] ;			/* line in script */
    char command[80] ;			/* script command */
    int search_frame = 0 ;		/* frame to search to */
    int playto_frame = 0 ;		/* frame to play to */
    char mode[80] ;
    int speed = 1 ;			/* playback speed */
    int i ;

    *frames_remaining = 0 ;
    while ((fgets(line,80,in)) != NULL)
    {
        if   (((strncmp("connect",line,7)) == 0)
         ||  ((strncmp("get",line,3)) == 0)
         ||  ((strncmp("blank",line,5)) == 0)
         ||  ((strncmp("hold",line,4)) == 0))
	    ;
        else if ((strncmp("search",line,6)) == 0)
	{
	    sscanf (line,"%s %d",command,&search_frame) ;
	    (*frames_remaining)++ ;
	}
        else if ((strncmp("playto",line,6)) == 0)
	{
	    sscanf (line,"%s %d %s %d",command,&playto_frame,
				       mode,&speed) ;
	    if (playto_frame >= search_frame)
	        for (i = search_frame+1 ; i <= playto_frame ; i++)
		    (*frames_remaining)++ ;
	    else
	        for (i = search_frame-1 ; i >= playto_frame ; i--)
		    (*frames_remaining)++ ;
	    search_frame = playto_frame ;
	}
    }
}
