.TH ANIMA_UTILITIES n "January 28 1991"
.SH NAME
anima_utilities \- combine, extract, genonemap, convert
.SH SYNOPSIS
.B combine
.BI \-i " filename1 filename2"
.BI \-o " combined"
.sp
.B extract
.BI \-i " filename "
.BI \-o " output"
.BI \-e " start finish"
.sp
.B genonemap
.BI \-i " filename "
.BI \-o " output"
.BI \-m " number"
.sp
.B convert
.BI \-i " filename "
.BI \-o " output"
.SH DESCRIPTION
\f3combine\f1 combines two Anima files and merges their footers.
The output is in "many map" Anima format, with an IFF header
for every frame.  Do not attempt to combine two files with
different spatial resolutions, because \f3Xanima\f1 and
\f3svanima\f1 cannot handle an Anima file with different
sized images within it.
.sp
\f3extract\f1 extracts frames from an Anima file, from frame
number "start" to "finish", into an Anima file.
.sp
\f3genonemap\f1 generates one color map and IFF header for
the entire Anima file.  This is recommended to prevent
color flashing from one frame to the next during playback
on an 8-bit workstation.  The \f3\-m\f1 option chooses
the number of entries in the color map.
\f3torus.tester\f1 is a sample \f3Anima\f1 file with a different
color map for each frame.
.sp
\f3convert\f1 converts from a Scry version 1.1 Anima file
to a Scry version 1.2 Anima file.  It is recommended that
genonemap be applied to the new file.
.SH AUTHOR
David Robertson
.SH "SEE ALSO"
.B anima_format(n)
