/* $Id: objutils.c,v 1.10 90/05/09 22:11:35 pturner Exp Locker: pturner $
 *
 * operations on objects (strings, lines, and boxes)
 *
 */

#include <math.h>
#include "globals.h"
#include "defines.h"

#define FIGURE 1
#define BOX 2
#define LINE 3
#define POLYLINE 4
#define POLYGON 5
#define STRING 6

int nboxes = 0;

struct boxstruct {
    double x1, y1, x2, y2;
    int color;
    int style;
    int active;
    int loctype;
} boxes[MAXBOXES];

int nlines = 0;

struct linestruct {
    double x1, y1, x2, y2;
    int color;
    int style;
    int arrow;
    double asize;
    int active;
    int loctype;
} lines[MAXLINES];

#define MAXSTRLEN 140

int nstrings = 0;

typedef struct {
    char s[MAXSTRLEN + 1];
    double x, y;
    double size;
    int rot;
    int font;
    int color;
    int loctype;
    int just;
} plotstr;

extern plotstr pstr[];

/*
 * initialize strings - mainly need to do the size parameter
 * fix lines also - arrowhead size
 */
initstr(pstr)
    plotstr pstr[];

{
    int i;

    for (i = 0; i < MAXSTR; i++) {
	pstr[i].s[0] = 0;
	pstr[i].x = pstr[i].y = 0.0;
	pstr[i].size = 1.0;
	pstr[i].rot = 0;
	pstr[i].font = 2;
	pstr[i].color = 1;
    }
    for (i = 0; i < MAXLINES; i++) {
	lines[i].asize = 1.0;
    }
}


/*
 * find the nearest object to (x,y)
 */
void find_item(x, y, type, numb)
    double x, y;
    int *type, *numb;
{
    int i;
    double tmp, xtmp1, ytmp1, xtmp2, ytmp2, m = 1e307, dx = xg2 - xg1, dy = yg2 - yg1;

    *type = -1;
    for (i = 0; i < MAXBOXES; i++) {
	if (isactive_box(i)) {
	    if (boxes[i].loctype) {
		get_view2world(boxes[i].x1, boxes[i].y1, &xtmp1, &ytmp1);
		get_view2world(boxes[i].x2, boxes[i].y2, &xtmp2, &ytmp2);
	    } else {
		xtmp1 = boxes[i].x1;
		ytmp1 = boxes[i].y1;
		xtmp2 = boxes[i].x2;
		ytmp2 = boxes[i].y2;
	    }
	    tmp = hypot((x - xtmp1) / dx, (y - ytmp1) / dy);
	    if (m > tmp) {
		*type = BOX;
		*numb = i;
		m = tmp;
	    }
	    tmp = hypot((x - xtmp1) / dx, (y - ytmp2) / dy);
	    if (m > tmp) {
		*type = BOX;
		*numb = i;
		m = tmp;
	    }
	    tmp = hypot((x - xtmp2) / dx, (y - ytmp1) / dy);
	    if (m > tmp) {
		*type = BOX;
		*numb = i;
		m = tmp;
	    }
	    tmp = hypot((x - xtmp2) / dx, (y - ytmp2) / dy);
	    if (m > tmp) {
		*type = BOX;
		*numb = i;
		m = tmp;
	    }
	}
    }
    for (i = 0; i < MAXLINES; i++) {
	if (isactive_line(i)) {
	    if (lines[i].loctype) {
		get_view2world(lines[i].x1, lines[i].y1, &xtmp1, &ytmp1);
		get_view2world(lines[i].x2, lines[i].y2, &xtmp2, &ytmp2);
	    } else {
		xtmp1 = lines[i].x1;
		ytmp1 = lines[i].y1;
		xtmp2 = lines[i].x2;
		ytmp2 = lines[i].y2;
	    }
	    tmp = hypot((x - xtmp1) / dx, (y - ytmp1) / dy);
	    if (m > tmp) {
		*type = LINE;
		*numb = i;
		m = tmp;
	    }
	    tmp = hypot((x - xtmp2) / dx, (y - ytmp2) / dy);
	    if (m > tmp) {
		*type = LINE;
		*numb = i;
		m = tmp;
	    }
	}
    }
    for (i = 0; i < MAXSTR; i++) {
	if (isactive_string(i)) {
	    if (pstr[i].loctype) {
		get_view2world(pstr[i].x, pstr[i].y, &xtmp1, &ytmp1);
		tmp = hypot((x - xtmp1) / dx, (y - ytmp1) / dy);
	    } else {
		tmp = hypot((x - pstr[i].x) / dx, (y - pstr[i].y) / dy);
	    }
	    if (m > tmp) {
		*type = STRING;
		*numb = i;
		m = tmp;
	    }
	}
    }
}

int isactive_line(lineno)
    int lineno;
{
    if (0 <= lineno && lineno < MAXLINES)
	return (lines[lineno].active);
    return (0);
}

int isactive_box(boxno)
    int boxno;
{
    if (0 <= boxno && boxno < MAXBOXES)
	return (boxes[boxno].active);
    return (0);
}

int isactive_string(strno)
    int strno;
{
    if (0 <= strno && strno < MAXSTR)
	return (pstr[strno].s[0]);
    return (0);
}

int next_line()
{
    int i;

    for (i = 0; i < MAXLINES; i++) {
	if (!isactive_line(i)) {
	    lines[i].active = TRUE;
	    nlines++;
	    return (i);
	}
    }
    errwin("Error - no lines available");
    return (-1);
}

int next_box()
{
    int i;

    for (i = 0; i < MAXBOXES; i++) {
	if (!isactive_box(i)) {
	    boxes[i].active = TRUE;
	    nboxes++;
	    return (i);
	}
    }
    errwin("Error - no boxes available");
    return (-1);
}

int next_string()
{
    int i;

    for (i = 0; i < MAXSTR; i++) {
	if (!isactive_string(i)) {
	    nstrings++;
	    return (i);
	}
    }
    errwin("Error - no strings available");
    return (-1);
}

kill_box(boxno)
    int boxno;
{
    if (isactive_box(boxno)) {
	boxes[boxno].active = FALSE;
	nboxes--;
    }
}

kill_line(lineno)
    int lineno;
{
    if (isactive_line(lineno)) {
	lines[lineno].active = FALSE;
	nlines--;
    }
}

kill_string(stringno)
    int stringno;
{
    if (isactive_string(stringno)) {
	pstr[stringno].s[0] = 0;
	nstrings--;
    }
}
