/* $Id: main.c,v 1.18 90/04/13 20:33:16 pturner Exp Locker: pturner $
 *
 * gr - Graphics for Exploratory Data Analysis
 * grtool - The Sunview version
 *
 * Grtool is Public Domain software written by Paul J. Turner.
 * Use at your own risk.
 *
 * Paul J. Turner
 * Department of Environmental Science and Engineering
 * Oregon Graduate Institute of Science and Technology
 * 19600 NW von Neumann Dr.
 * Beaverton, OR  97006-1999
 * pturner@cse.ogi.edu
 * tektronix!ogicse!pturner
 *
 * main.c - entry point
 *
 */

/* for globals.h */
#define MAIN

#include <stdio.h>
#include <pwd.h>
#include "defines.h"
#include "globals.h"

/* special cases from params.c */
#define	WORLD      41
#define	TICS     27
extern int noauto_world;	/* defined in files.c TODO: move it to
				 * globals.h */
extern int noauto_tics;		/* defined in files.c TODO: move it to
				 * globals.h */

void main(argc, argv)
    int argc;
    char *argv[];

{
    FILE *fp;
    int i, pstat, parmsread, ftype = 0, src = 0, auto_type = 0;
    char grtoolrc_file[256], *s, *getenv();
    struct passwd *p;

    /* TODO move these externs */
    extern int ptofile;		/* set to TRUE if printing to a file */
    extern char printstr[];	/* print to this file */
    extern int noerase;
    extern char hp_prstr1[], hp_prstr2[], ps_prstr[], hplj_prstr[], noprint[];

    /* initialize plots, strings, graphs */
    initplots();
    storegraph(MAXGRAPH);
    initgraphs();

    /* initialize device, here tdevice is always 0 = Sunview */
    device = tdevice;

    /* check for .grtoolrc file in effective users home dir */
    /* maybe I should use getenv("HOME.. ? */
    p = getpwuid(geteuid());
    strcpy(grtoolrc_file, p->pw_dir);
    strcat(grtoolrc_file, "/.grtoolrc");
    if ((fp = fopen(grtoolrc_file, "r")) != NULL) {
	fclose(fp);
	getparms(grtoolrc_file);
    }
    pstat = FALSE;
    parmsread = FALSE;
    plfile[0] = 0;

    /*
     * check for changed printer spooling strings
     */
    if ((s = getenv("GR_HP_PRSTR1")) != NULL) {
	strcpy(hp_prstr1, s);
    }
    if ((s = getenv("GR_HP_PRSTR2")) != NULL) {
	strcpy(hp_prstr2, s);
    }
    if ((s = getenv("GR_PS_PRSTR")) != NULL) {
	strcpy(ps_prstr, s);
    }
    if ((s = getenv("GR_HPLJ_PRSTR")) != NULL) {
	strcpy(hplj_prstr, s);
    }
    /*
     * check for changed hardcopy device
     */
    if ((s = getenv("GR_HDEV")) != NULL) {
	hdevice = atoi(s);
    }
    setprstring(hdevice);

    if (argc >= 2) {
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'a':	/* autoscale type */
		    i++;
		    if (i == argc) {
			fprintf(stderr, "Missing argument for autoscale flag\n");
			break;
		    }
		    if (!strcmp("x", argv[i])) {
			auto_type = 1;
		    } else if (!strcmp("y", argv[i])) {
			auto_type = 2;
		    } else if (!strcmp("xy", argv[i])) {
			auto_type = 3;
		    } else {
			fprintf(stderr, "%s: Improper argument for -a flag should be one of 'x', 'y', 'xy'\n", argv[0]);
		    }
		    break;
		case 'd':	/* select hardcopy device */
		    i++;
		    if (i == argc) {
			fprintf(stderr, "Missing argument for hardcopy device select flag\n");
			break;
		    }
		    hdevice = atoi(argv[i]);
		    setprstring(hdevice);
		    break;
		case 'l':	/* perform logarithmic transformation after
				 * reading data */
		    i++;
		    if (i == argc) {
			fprintf(stderr, "Missing argument for log transform flag\n");
			break;
		    }
		    if (!strcmp("x", argv[i])) {
			dologtransform = 1;
			xticslog = 1;
		    } else if (!strcmp("y", argv[i])) {
			dologtransform = 2;
			yticslog = 1;
		    } else if (!strcmp("xy", argv[i])) {
			dologtransform = 3;
			xticslog = 1;
			yticslog = 1;
		    } else {
			fprintf(stderr, "%s: Improper argument for -l flag should be one of 'x', 'y', 'xy'\n", argv[0]);
			dologtransform = FALSE;
			xticslog = 0;
			yticslog = 0;
		    }
		    break;
		case 'f':	/* to print to a file */
		    i++;
		    if (i == argc) {
			fprintf(stderr, "Missing file name for printing\n");
		    } else {
			strcpy(printstr, argv[i]);
			ptofile = TRUE;
		    }
		    break;
		case 'h':	/* plot using hardcopy device */
		    hardcopyflag = TRUE;
		    break;
		case 'i':	/* IHL format */
		    ftype = 2;
		    break;
		case 'n':	/* n xy format */
		    ftype = 1;
		    break;
		case 'p':	/* read a parameter file */
		    i++;
		    if (i == argc) {
			fprintf(stderr, "Missing parameter file name\n");
		    } else {
			strcpy(plfile, argv[i]);
			getparms(plfile);
			parmsread = plfile[0];
		    }
		    break;
		case 'r':	/* results from regression routines to file */
		    i++;
		    if (i == argc) {
			fprintf(stderr, "Missing results file name\n");
		    } else {
			strcpy(resfile, argv[i]);
		    }
		    break;
		case 's':	/* set source type */
		    i++;
		    if (i == argc) {
			fprintf(stderr, "Missing argument for data source parameter\n");
			break;
		    }
		    src = atoi(argv[i]);
		    if (!(src >= 0 && src <= 2)) {
			fprintf(stderr, "Illegal source with -s flag, must be 0, 1, or 2\n");
			fprintf(stderr, " 0 ... read from a disk (default)\n");
			fprintf(stderr, " 1 ... read from a pipe\n");
			fprintf(stderr, " 2 ... read from stdin\n");
		    }
		    /* we are in a pipe or re-direct */
		    if (src == 2) {
			if (getdata("STDIN", src, ftype)) {
			    pstat = TRUE;
			    ftype = 0;
			}
			src = 0;
		    }
		    break;
		default:
		    fprintf(stderr, "No option %c\n", argv[i][1]);
		    i++;
		}
	    } else {
		/* a data file (we hope) */
		if (!(i == argc)) {
		    if (getdata(argv[i], src, ftype)) {
			pstat = TRUE;
			ftype = 0;
			src = 0;
		    }
		}
	    }
	}
/*
 * if successfully read data and -l set logtransform
 * then compute logs for all active sets
 */
	if (pstat && dologtransform) {
	    logtrans();
	    dologtransform = FALSE;
	}
/*
 * if successfully read data and no parameter
 * file was read then find appropriate defaults
 */
	if ((pstat) && (!parmsread)) {
	    if (!noauto_world)
		defaultgraph();
	    if (!noauto_tics)
		defaulttics(0);
	}
/*
 * if auto scaling type set with -a option, then scale appropriate axis
 */
	if (auto_type) {
	    switch (auto_type) {
	    case 1:
		defaultx();
		defaultxtics(0);
		break;
	    case 2:
		defaulty();
		defaultytics(0);
		break;
	    case 3:
		defaultgraph();
		defaulttics(0);
		break;
	    }
	}
    }
/*
 * initialize the Hershey fonts
 */
    hselectfont(curfont);
/*
 * if -h on command line just plot the graph and quit
 * - sunview is not a legitimate device
 */
    if (hardcopyflag) {
	if (hdevice == 0) {
	    fprintf(stderr, "%s: Device 0 (Sunview) is not a legitimate device for batch plotting\n", argv[0]);
	    exit(1);
	}
	noerase = 1;
	plotone();
	leavegraphics();
	exit(0);
    }
/*
 * Check to see if we are in Sunview
 */
    if (getenv("WINDOW_PARENT") == NULL) {
	fprintf(stderr, "%s: You must be running Sunview\n", argv[0]);
	exit(1);
    }
/*
 * go window things up - do_main_loop is in grtool.c
 */
    do_main_loop(argc, argv);
}
