/*****************************************************************************/
/* 				   anim.y				     */
/*===========================================================================*/
/* 									     */
/*	-- anim.y	is the anim language				     */
/* 									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/* 									     */
/*****************************************************************************/

%{
#include "runtime.h"
#include "symbol.h"
#include "inter.h"
%}

/*__________________________  Terminal Symbols  _____________________________*/
%token NUMBER
%token IDENTIFIER
%token DOTDOT
%token IS
%token AT
%token SINE
%token COSINE
%token LOG
%token EXP
%token GRAVITY
%token DO
%token ';'
%token ':'
%token '='
%token ','
%token '{'
%token '}'
%token '+'
%token '-'
%token '*'
%token '/'
%token '^'

%%

/*===========================================================================*/
/* 				Grammar Rules				     */
/*===========================================================================*/

procdec
	: /* LAMBDA */
	| IDENTIFIER '{' statements '}' procdec	{ create_proc($1) ; }
	| DO IDENTIFIER ';' procdec		{ add_order($2) ; }

statements
	: /* LAMBDA */
	| descriptors statements
	| triggers statements
	| vardecls statements

descriptors
	: IDENTIFIER IS IDENTIFIER ';'		{ add_desc($1,$3) ; }
	| IDENTIFIER IS NUMBER ';'		{ add_desc($1,$3) ; }

triggers
	: IDENTIFIER AT NUMBER ';'		{ add_trig($1,$3) ; }

vardecls
	: IDENTIFIER '=' interval moreints ';'	{ add_var($1,$3,$4) ; }

moreints
	: /* LAMBDA */				{ $$=last_inter() ; }
	| IDENTIFIER interval moreints		{ $$=add_inter($1,$2,$3) ; }

interval
	: forder ':' samplepts			{ $$=create_inter($1,$3) ; }
	| samplepts				{ $$=create_inter_def($1) ; }

samplepts
	: NUMBER DOTDOT samplepts		{ $$=add_point($1,$3) ; }
	| NUMBER				{ $$=last_point($1) ; }

forder
	: NUMBER
	| SINE
	| COSINE
	| LOG
	| EXP
	| GRAVITY


