/*
 * error.h
 * $Log:	error.h,v $
 * Revision 4.0  91/07/17  14:30:27  kolb
 * Initial version.
 */
#ifndef ERROR_H
#define ERROR_H
/*
 * Error severity codes, passed to user-provided RLerror()
 * function which optionally prints and optionally exits.
 *
 * RL_ADVISE	Message may safely be safely suppressed, though
 *		the resulting image may not be exactly what you expect.
 * RL_WARN	Message should probably be printed; image will most
 *		likely be affected.
 * RL_ABORT	Message should be printed -- couldn't perform a request.
 *		The resulting image will be affected.
 * RL_PANIC	Fatal error -- call to RLerror() must not return.
 */
#define RL_ADVISE	0	/* Advisory */
#define RL_WARN		1	/* Warning */
#define RL_ABORT	2	/* Aborted */
#define RL_PANIC	3	/* Panic */
 
extern void RLerror();		/* application-supplied reporting routine */
#endif /* ERROR_H */
