# include <stdio.h>

# include "getopt.h"

# define STATE_SIZE	256

# define COLOR_MIN	1
# define COLOR_MAX	256

# define ranrange(min, max)	((random() % (max - min)) + min)

struct color_opts {
	char	*col_name;
	int	*col_val;
	int	col_set;
};

static int	redmax = COLOR_MAX,	redmin = COLOR_MIN;
static int	greenmax = COLOR_MAX,	greenmin = COLOR_MIN;
static int	bluemax = COLOR_MAX,	bluemin = COLOR_MIN;

static struct color_opts color_opts[] = {
	{ "redmax",	&redmax,	0 },
	{ "redmin",	&redmin,	0 },
	{ "greenmax",	&greenmax,	0 },
	{ "greenmin",	&greenmin,	0 },
	{ "bluemax",	&bluemax,	0 },
	{ "bluemin",	&bluemin,	0 },
	{ 0,		0,		0 }
};

static struct option lopts[] = {
	{ "redmax",	1, 0, 0 },
	{ "redmin",	1, 0, 0 },
	{ "greenmax",	1, 0, 0 },
	{ "greenmin",	1, 0, 0 },
	{ "bluemax",	1, 0, 0 },
	{ "bluemin",	1, 0, 0 },
	{ 0,		0, 0, 0 }
};

int		option_index;
struct option		*_getopt_long_options;

main(argc, argv)
	int		argc;
	char		**argv;
{
	extern long	time();
	extern long	random();
	extern char	*malloc();
	int		lines;
	char		*state;
	int		center, red, green, blue;
	int		n, i;

	option_index = 0;
	while ((n = getopt_long(argc, argv, "", lopts, &option_index)) != EOF) {
		if (n != 0) {
			fprintf(stderr, "n != 1\n");
			usage();
		}
		if (optarg == NULL) {
			fprintf(stderr, "optarg == NULL\n");
			usage();
		}

		/*fprintf(stderr, "option = %s, optarg = %s\n",
			lopts[option_index].name, optarg);*/

		for (i = 0; color_opts[i].col_name != NULL; i++) {
			if (strcmp(color_opts[i].col_name, lopts[option_index].name) == 0) {
				*color_opts[i].col_val = atoi(optarg);
				check(*color_opts[i].col_val);
				break;
			}
		}
	}

	if (redmin >= redmax) {
		fprintf(stderr, "redmin >= redmax\n");
		exit(1);
	}
	if (greenmin >= greenmax) {
		fprintf(stderr, "greenmin >= greenmax\n");
		exit(1);
	}
	if (bluemin >= bluemax) {
		fprintf(stderr, "bluemin >= bluemax\n");
		exit(1);
	}

	if ((state = malloc(STATE_SIZE)) == NULL) {
		perror("malloc");
		exit(1);
	}

	initstate(time(0), state, STATE_SIZE);

	for (lines = 0; lines < 256; lines++) {
		red = ranrange(redmin, redmax);
		green = ranrange(greenmin, greenmax);
		blue = ranrange(bluemin, bluemax);

		printf("%d\t%d\t%d\n", red, green, blue);
		fflush(stdout);
	}

	exit(0);
}

check(num) {
	if (num < COLOR_MIN) {
		fprintf(stderr, "color min/max must be greater than or equal to 1\n");
		usage();
	}

	if (num > COLOR_MAX) {
		fprintf(stderr, "color min/max must be less than or equal to 256\n");
		usage();
	}
}

usage() {
	fprintf(stderr, "usage: cmap [+redmin #] [+redmax #]\n\
            [+greenmin #] [+greenmax #]\n\
            [+bluemin #] [+bluemax #]\n\
            (where # must be between 0 and 256)\n");
	exit(1);
}
