#ifndef lint
static       char    rcsid[] = "$Header: coord.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	coord.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * get coordinates from the DXF file
 */

VOID	CoordDxfParse(number, point)
INT	number;
FLOAT	point[3];
{
	if (Group->code != (number + 10))
		DXFERR("wrong group code (%d) for X value of a point\n",
			Group->code);

	point[0] = Group->fltnum;

	GetNextGroup();

	if (Group->code != (number + 20))
		DXFERR("wrong group code (%d) for Y value of a point\n",
			Group->code);

	point[1] = Group->fltnum;

	GetNextGroup();

	if (Group->code != (number + 30))
		DXFERR("wrong group code (%d) for Z valuer of a point\n",
			Group->code);

	point[2] = Group->fltnum;
}

/*
 * check two points if they are the same
 * if true, return 1, else 0
 */

INT	CoordSame(p, q)
FLOAT	p[3], q[3];
{
	if (fabs(p[0] - q[0]) > TOE)
		return(0);

	if (fabs(p[1] - q[1]) > TOE)
		return(0);

	if (fabs(p[2] - q[2]) > TOE)
		return(0);

	return(1);
}

/*
 * Output a coordinate into DXF file
 */

VOID	CoordDxfOutput(number, point)
INT	number;
FLOAT	point[3];
{
	fprintf(OutFile, "%3d\n%g\n", number + 10, point[0]);
	fprintf(OutFile, "%3d\n%g\n", number + 20, point[1]);
	fprintf(OutFile, "%3d\n%g\n", number + 30, point[2]);
}

/*
 * calculate distace bwteen two points
 */

FLOAT	CoordDistance(p, q)
FLOAT	p[3], q[3];
{
	FLOAT	vector[3];

	VecSub(p, q, vector);
	return(VecLength(vector));
}
