/* surface.h */

#ifndef _SURFACE_H_
#define _SURFACE_H_

#include "pointlist.h"
#include "vectorlist.h"
#include "vertexlist.h"
#include "patchlist.h"
#include "material.h"
#include "geom_methods.h"

typedef struct SURFACE {
	int 	id;
	MATERIAL *material;
	POINTLIST *points;
	VECTORLIST *normals;
	struct VERTEXLIST *vertices;
	struct PATCHLIST *faces;
} SURFACE;

#include <stdio.h>
#include "geom_methods.h"

extern SURFACE *SurfaceCreate(MATERIAL *material, 
			      POINTLIST *points, VECTORLIST *normals,
			      struct VERTEXLIST *vertices, struct PATCHLIST *faces);
extern void SurfaceDestroy(SURFACE *surface);
extern struct GEOM_METHODS *SurfaceMethods(void);
extern void SurfacePrint(FILE *out, SURFACE *surface);

extern POINT *SurfaceInstallPoint(SURFACE *surf, POINT *point);
extern VECTOR *SurfaceInstallNormal(SURFACE *surf, VECTOR *normal);
extern struct VERTEX *SurfaceInstallVertex(SURFACE *surf, POINT *point, VECTOR *normal, RGB *color);

#endif /*_SURFACE_H_*/
