/* pointoctree.h: octrees containing points */

#ifndef _POINTOCTREE_H_
#define _POINTOCTREE_H_

#include "point.h"
#include "Octree.h"

/* same layout as struct OCTREE in Octree.h. Different number of chldren is allowed */
typedef struct POINTOCTREE {
	struct POINT *point;
	struct POINTOCTREE *child[8];
} POINTOCTREE;

#define PointOctreeCreate()	((POINTOCTREE *)OctreeCreate())

#define PointOctreeAdd(poctree, ppoint)     \
        (POINTOCTREE *)OctreeAdd((OCTREE *)poctree, (void *)ppoint, (int (*)(void *, void *))PointCompare)

#define PointOctreeFind(poctree, ppoint)     \
        (POINT *)OctreeFind((OCTREE *)poctree, (void *)ppoint, (int (*)(void *, void *))PointCompare)

#define PointOctreeDestroy(poctree) \
        OctreeDestroy((OCTREE *)poctree)

/* returns 0 if the two points are equal, 
 * 1 if p1->x < p2->x 	2 if p->x > p2->x
 * 3 if p1->y < p2->y 	4 if p->y > p2->y
 * 5 if p1->z < p2->z 	6 if p->z > p2->z */
extern int PointCompare(POINT *p1, POINT *p2);

#endif /*_POINTOCTREE_H_*/
