/* namedvertex.c */

#include <string.h>
#include "namedvertex.h"
#include "Memory.h"
#include "Bintree.h"
#include "vertexlist.h"

#ifdef BETTER_MEMMAN
static STORAGE *namedvertexlistStor = (STORAGE *)NULL;
#define NEWNAMEDVERTEXLISTNODE()  	(NAMEDVERTEXLIST *)New(sizeof(NAMEDVERTEXLIST), &namedvertexlistStor)
#define DISPOSENAMEDVERTEXLISTNODE(ptr) Dispose((unsigned char *)(ptr), &namedvertexlistStor)
#else /*BETTER_MEMMAN*/
#define NEWNAMEDVERTEXLISTNODE()	(NAMEDVERTEXLIST *)Alloc(sizeof(NAMEDVERTEXLIST))
#define DISPOSENAMEDVERTEXLISTNODE(ptr) Free((char *)ptr, sizeof(NAMEDVERTEXLIST))
#endif /*BETTER_MEMMAN*/

static int NamedVertexListNameCompare(NAMEDVERTEXLIST *nvl, char *name)
{
	return strcmp(nvl->name, name);
}

static int NamedVertexListCompare(NAMEDVERTEXLIST *nvl1, NAMEDVERTEXLIST *nvl2)
{
	return strcmp(nvl1->name, nvl2->name);
}

static NAMEDVERTEXLIST *NewNamedVertexList(char *name, VERTEX *vertex)
{
	NAMEDVERTEXLIST *nvl;

	nvl = NEWNAMEDVERTEXLISTNODE();
	nvl->name = name;
	nvl->vertices = VertexListAdd(VertexListCreate(), vertex);

	return nvl;
}

NAMEDVERTEXTREE *NamedVertexAdd(NAMEDVERTEXTREE *namedvertices, char *name, VERTEX *vertex)
{
	NAMEDVERTEXLIST *nvl;

	if (!(nvl = (NAMEDVERTEXLIST *)BinTreeFind((BINTREE *)namedvertices, name, (int (*)(void *, void *))NamedVertexListNameCompare))) {
		nvl = NewNamedVertexList(name, vertex);
		return (NAMEDVERTEXTREE *)BinTreeAdd((BINTREE *)namedvertices, nvl, (int (*)(void *, void *))NamedVertexListCompare);
	} else {
		nvl->vertices = VertexListAdd(nvl->vertices, vertex);
		return namedvertices;
	}
}

VERTEX *NamedVertexFind(NAMEDVERTEXTREE *namedvertices, char *name, POINT *point, VECTOR *normal)
{
	NAMEDVERTEXLIST *nvl;

	if ((nvl = (NAMEDVERTEXLIST *)BinTreeFind((BINTREE *)namedvertices, name, (int (*)(void *, void *))NamedVertexListNameCompare))) {
		return VertexListFind(nvl->vertices, point, normal);
	}

	return (VERTEX *)NULL;
}

static void DisposeNamedVertexList(NAMEDVERTEXLIST *nvl)
{
	VertexListDestroy(nvl->vertices);
	DISPOSENAMEDVERTEXLISTNODE(nvl);
}

void NamedVertexTreeDestroy(NAMEDVERTEXTREE *namedvertices)
{
	BinTreeIterate((BINTREE *)namedvertices, (void (*)(void *))DisposeNamedVertexList);
	BinTreeDestroy((BINTREE *)namedvertices);
}


