/* message.h: message dialogs and what to do after the user clicks on 
 * the OK button of it */

#ifndef _MESSAGE_H_
#define _MESSAGE_H_

/* initialisations ... called once from main.c */
extern void InitMessage(Widget topLevel, Arg *args, int nrargs);

/* sets the procedure to be called when the user clicks on the OK
 * button on the message dialog -- returns the previous routine
 * that was used for this so you can restore it later */
extern void (*SetAfterMessageProc(void (*proc)(void)))(void);

/* displays a message box */
extern void Message(char *text, ...);

#endif /*_MESSAGE_H_*/
