/* geom.h */
#ifndef _GEOM_H_
#define _GEOM_H_

#include <stdio.h>
#include "geom_type.h"
#include "geomlist.h"

extern GEOM *GeomCreate(void *obj, struct GEOM_METHODS *methods);
extern void GeomPrint(FILE *out, GEOM *geom);
extern float *GeomBounds(GEOM *geom);
extern void GeomDestroy(GEOM *geom);
extern int GeomIsAggregate(GEOM *geom);
extern struct GEOMLIST *GeomPrimList(GEOM *geom);
extern struct PATCHLIST *GeomPatchList(GEOM *geom);
extern PATCH *GeomIntersect(GEOM *geom, RAY *ray, float mindist, float *maxdist, int ShadowTesting);
extern GEOM *GeomDuplicate(GEOM *geom); /* needed for shaftculling */

#define GeomBounded(geom) (geom->bounded)

/* include patchlist.h when using this */
#define GeomIsPatchlist(geom) (geom->methods == &patchlistMethods)
/* include compound.h when using this */
#define GeomIsCompound(geom) (geom->methods == &compoundMethods)
/* include surface.h when using this */
#define GeomIsSurface(geom) (geom->methods == &surfaceMethods)

#endif /*_GEOM_H_*/

