#include <stdio.h>

#include "GraphicsGems.h"
#include "data_structure.h"
#include "render.h"

int write_out_intensity(fl)
FILE *fl;
{
	int i,j,k,n;
	if (fl == NULL) return;
        if (intensity_out_flag==For_Grids_Only){
	fprintf(fl,"%d\n",color_channels);
	fprintf(fl,"%d\n",number_objects); 
	for (i=0; i < number_objects; i++){
		int grid_points=object[i].grid_v_reso*object[i].grid_h_reso;
		fprintf(fl,"%d %d\n",object[i].grid_v_reso,object[i].grid_h_reso);
		for (j=0;j < grid_points; j++){
			for(k=0; k < color_channels; k++)
				fprintf(fl,"%g ",
				 object[i].grid[j].normalized_flux_density[k]);
			fprintf(fl,"\n");
		}
	}
	}
        else dump_main_surface_illumination_values(fl);
}

int read_in_intensity(fl)
FILE *fl;
{
        int i,j,k,n;
	int c,no;
	fscanf(fl,"%d",&c); if (c!=color_channels) 
		error("Different number of channels.");
	fscanf(fl,"%d",&no); if (no!=number_objects) 
		error("Different number of objects.");
	for (i=0; i < number_objects; i++){
		int g1,g2;
		fscanf(fl,"%d%d",&g1,&g2);
		if ((g1!=object[i].grid_v_reso)
			||(g2!=object[i].grid_h_reso))
			error("Object grid mismatch");
		for (j=0,n=object[i].grid_v_reso*object[i].grid_h_reso;
						j < n; j++)
		    for(k=0; k < color_channels; k++)
		      fscanf(fl,"%lg",
		      &(object[i].grid[j].normalized_flux_density[k]));
	}
	fclose(fl);
}
int dump_main_surface_illumination_values(fl)
FILE *fl;
{
	int i,k;
	for (i=0; i < number_objects; i++){
		for(k=0; k < color_channels; k++)
                	fprintf(fl,"%g ",object[i].normalized_flux_density[k]);
		fprintf(fl,"\n");
	}
}
