/**********************************************************************/
/*                                                                    */
/* walk.h : walk-through program primitives                           */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef WALK_H
#define WALK_H

/**********************************************************************/
/* Constants                                                          */
/**********************************************************************/
#ifndef TRUE 
#define TRUE 1
#endif /* TRUE */
#ifndef FALSE
#define FALSE 0
#endif /* FALSE */

#define LARGEZ 10000.0
#define ANGLE_SHOCK_ABSORBER 0.4   /* Scale rotational movements     */
#define COORD_SHOCK_ABSORBER 0.04  /* Scale translational movements  */

/* Orientation Modal Flags */
#define STILL -1        /* Not moving */
#define ORIENT_ROT 0    /* Changing orientation (rotation in X,Y)     */
#define ORIENT_SPIN 1   /* Changing orientation (rotation in Z)       */ 
#define ORIENT_TRANSL 2 /* Changing orientation (translate in X,Y)    */
#define ORIENT_ZOOM 3   /* Changing orientation (zoom=translate in Z) */
#define ORIENT_SCALE 4  /* Changing orientation (zoom=translate in Z) */
#define ORIENT_ABS 5    /* Changing orientation to absolute position  */
#define PREORIENT 10    /* Reading orientation changes from file      */

/* Sessional Option Flags */
#define NOLOG 0         /* Logging session                            */
#define DOLOG 1         /* Not loggin session                         */
#define DEBUG 1         /* Debugging messages on                      */
#define NODEBUG 0       /* Debugging messages off                     */
#define SHADE_TRIA 3    /* Shade patches using triangular mesh        */
#define SHADE_QUAD 4    /* Shade patches using quadralateral mesh     */
#define NO_SHADE 5      /* Draw mesh only                             */

/**********************************************************************/
/* Option structures                                                  */
/**********************************************************************/
typedef struct { int x,y,z; } iVector;   /* integer vector            */
typedef struct { float x,y,z; } fVector; /* float vector              */

typedef struct {
  float scrnaspect;     /* aspect ratio value for window              */
  long xscrnsize;       /* size of screen in x used to set aspect ratio */
  long zfar;            /* maximum z in z-buffer                      */
  int UsePrefsize;      /* Use preferred size of window               */
  int UsePrefpos;       /* Use preferred position of window           */
  int UseRGB;           /* Use RBG mode                               */
  int UseDoubleBuf;     /* Use doublebuffering                        */
  int UseZBuf;          /* Use Zbuffering                             */
  int UseAccBuf;        /* Use Abuffering                             */
  int UsePanel;         /* Use panels                                 */
  int GraphInitialized; /* Graphics okay                              */
  int UseVCR;           /* Record onto VCR                            */
  int VCRmode;          /* VCR mode                                   */
  int gamma;            /* Use gamma correction                       */
  int FullScreen;       /* Display full screen. No border             */
} SystemAttrib;

typedef struct {
  int debug;            /* Debug ?                                    */
  int mode;             /* Current state of movement                  */
  int log;              /* Log current session camera movements       */
  float ZoomFactor;     /* How much to scale for SCALEing             */
  long shademodel;      /* Current shademodel (FLAT or GOURAUD or NO_SHADE) */
  long shadeprim;       /* Shade TRIANGLES or QUADRALATERALS          */
  int shadeBW;          /* Black and white outline                    */
  char *data_dir;       /* Data directory (patches)                   */
  int draw_axis;        /* Draw the xyz axis in scene                 */
  float RGBscale;       /* Scale colours by this much                 */
} OptionType;           /* User options                               */

/**********************************************************************/
/* Structures for movement */
/**********************************************************************/
#define XDIR 'x'        /* X direction for h/w matrix rotations       */
#define YDIR 'y'        /* Y direction for h/w matrix rotations       */
#define ZDIR 'z'        /* Z direction for h/w matrix rotations       */
#define X 0
#define Y 1
#define Z 2

/* Camera attributes */
typedef struct {
  Vector lookFrom;	/* Position looking from                      */
  Vector lookAt;	/* Position looking at                        */
  Vector lookUp;	/* Define up for camera                       */
  int fovx, fovy;       /* Field of view in x,y                       */
  double near, far;	/* Near and far clipping planes               */
  int xRes, yRes;       /* Resolution of viewing plane                */
  unsigned long *buffer;/* Buffer containing image from current view  */
  double bank;		/* Bank angle (relative to up)                */
} AbsMovement;

/* Movement movement status */
typedef struct {        
  iVector om, m;        /* Old, current mouse (x,y) position in window */
} MouseMovement;

typedef struct {
  iVector om, m;	/* old and new mouse positions in (x,y)       */
  double rot[3];        /* View rotation amount                       */
  double transl[3];     /* View translation amount                    */
/*  Matrix viewmat; */  /* View transformation                        */
} RelMovement;          /* Keep track of eye movement                 */

typedef struct movement{/* Movement = relative or absolute movement   */
  char mtype;           /* Movement type                              */
  AbsMovement *amove;
  RelMovement *rmove;
  struct movement *next;
} Movement;

/**********************************************************************/
/* kernal stuff for Abuffering (not used)                             */
/**********************************************************************/
#define MAXSAMPLES  64

/* A sample is x,y fractional offsets from pixel center and a weight. */
typedef struct {
    float x, y, weight;
} SAMPLE;

/* A kernel is an array of samples */
typedef struct {
    int numsamples;
    SAMPLE samples[MAXSAMPLES];
} KERNEL;

/**********************************************************************/
#define MAX_ENTRIES 10   /* Maximum menu entries */

/**********************************************************************/
/* Function prototypes and externs */
/**********************************************************************/
extern SystemAttrib System;
extern OptionType Option;
extern Matrix objmat;
extern Matrix Identity;
extern AbsMovement Viewer;
extern RelMovement view; 
extern MouseMovement Mouse;
extern int moves_logged;
extern FILE *movefile;
extern char *movefilename;
extern Movement *Autoview;
extern Movement *Mtail;
extern FILE *scenefile;  
extern int KernelId;
extern char **Kernels;
extern int NumKernels;
extern char *KernelFile;
extern char *ProgName;
extern char *WindowName;
extern long WindWid; 
extern long WindXorigin, WindYorigin;
extern long WindXsize, WindYsize;
extern long PanelWid;
extern long HelpWid;
extern char *HelpCmd;
extern long Menu;
extern fmfonthandle FontScreen, FontScreen5, FontScreen8, FontScreen10;
extern fmfontinfo FontScreenInfo, FontScreen5Info, 
  FontScreen8Info, FontScreen10Info;
extern void CopyViewer();
extern void CopyViewChg();

#endif /* WALK_H */
