/**********************************************************************/
/* draw.c                                                             */
/*                                                                    */
/* Routines to draw meshes of polygons using GOURAUD, FLAT shading or */
/* wireframe.                                                         */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          *
/**********************************************************************/
#include <stdio.h>
#include <string.h>
#include <gl/gl.h>
#include <gl/device.h>
#include <fmclient.h>
#define IRIS4D 1
#include "geo.h"
#include "walk.h"
#include "scene.h"

extern SMesh Scene;
/**********************************************************************/
/* Convert Spectra into RGB triples                                   */
/* Assume first 3 samples of spectra are r,g,b.                       */
/**********************************************************************/
void SpectraToRGB(pptr)
     SPolygon *pptr;
{
  int c,v;

  /* Scale the intensity */
  for (c=0;c<MAX_SPECTRA_SAMPLES;c++) {
    for(v=0;v<pptr->numVert;v++) {
      if (pptr->vtx_B[v][c] > 0.9999)
	pptr->vtx_B[v][c] = 0.9999; 
    }
    if (pptr->B[c] > 0.9999)
      pptr->B[c] = 0.9999;
  }
}

/**********************************************************************/
/* Draw a polygon in a mesh for an object */
/**********************************************************************/
void Draw_Polygon(pptr)
     SPolygon *pptr;
{
  int i, j;
  float n[3], v[3], c[3];
  int vin[4];                    /* Order of vertices to draw */

  /* Set default vertex drawing order */
  vin[0] = 0; vin[1] = 1; vin[2] = 2; vin[3] = 3;

  /* Draw triangulated scene. Only need to triangulate quads */
  if (Option.shadeprim == SHADE_TRIA) {
    if (pptr->class == PATCH) { 

      /* Triangulate quad by splitting along 2 vertices with most
	 similiar colour */
      if (fabs(pptr->vtx_B[0] - pptr->vtx_B[2]) >
	  fabs(pptr->vtx_B[3] - pptr->vtx_B[1])) {
	vin[0] = 0; vin[1] = 3; vin[2] = 1; vin[3] = 2; 
      } else {
	vin[0] = 1; vin[1] = 2; vin[2] = 0; vin[3] = 3; 
      }
    }
  } 

  if (Option.shadeprim == NO_SHADE) {
    bgnclosedline(); 
  } 
  else if (Option.shadeprim == SHADE_TRIA) {
    if (pptr->class == PATCH) bgntmesh();
    else bgnpolygon();
  } else if (Option.shadeprim == SHADE_QUAD) {
    bgnpolygon();
  }
  
  for(i=0;i<pptr->numVert;i++) {
    if (Option.shademodel == GOURAUD) {
      c[0] = pptr->vtx_B[vin[i]][0]; c[1] = pptr->vtx_B[vin[i]][1];
      c[2] = pptr->vtx_B[vin[i]][2];
    } else if ((Option.shadeBW == TRUE) && (Option.shadeprim == NO_SHADE)) {
      c[0] = 1.0; c[1] = 1.0; c[2] = 1.0;
    } else {
      c[0] = pptr->B[0]; c[1] = pptr->B[1]; c[2] = pptr->B[2];
    }
    c[3] = 0.0;

    if (Option.RGBscale != 1.0) {
      for (j=0;j<3;j++)	
	c[j] = c[j] * Option.RGBscale;
      if (c[j] > 1.0) c[j] = 1.0;
    }
    
    if (Option.shadeprim != NO_SHADE) {
      n[0] = pptr->normal[vin[i]].x; n[1] = pptr->normal[vin[i]].y; 
      n[2] = pptr->normal[vin[i]].z;
      n3f(n);
    }
    
    v[0] = pptr->vertex[vin[i]].x; v[1] = pptr->vertex[vin[i]].y;
    v[2] = pptr->vertex[vin[i]].z;
    c4f(c);
    v3f(v);
  }

  if (Option.shadeprim == NO_SHADE) {
    endclosedline(); 
  } else if (Option.shadeprim == SHADE_TRIA) {
    if (pptr->class == PATCH) endtmesh();
    else endpolygon();
  } else if (Option.shadeprim == SHADE_QUAD) {
    endpolygon();
  }
}

/**********************************************************************/
/* Draw a polygonal mesh of an object */
/**********************************************************************/
void Draw_Mesh()
{
  int i;
  SPolygon *pptr;

  /*  if (Option.shadeprim == NO_SHADE)
      depthcue(1); */
  for (i=0, pptr = Scene.polys; i<(Scene.num_polys);i++, pptr++)
    Draw_Polygon(pptr);
  /* if (Option.shadeprim == NO_SHADE)
     depthcue(0); */
}
