/**********************************************************************/
/* radmisc.h : include misc stuff for rad.c                           */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/

/**********************************************************************/
/* Prototypes */
/**********************************************************************/
int IsLeaf();
void Find_Receivers();
Polygon *FindShootPatch();           
void ComputeFormfactors();           
void Distribute_Rad();
void Make_ReceiverList();
void ff_Hemicube();
void Subdivide_Elements();

/**********************************************************************/
extern OptionType Option;            /* Program options */
extern RadParams ReadLog;            /* Radiosity parameters */
extern double *formfactors;          /* Hemicube form factors */
extern Hemicube hemicube;            /* Hemicube */
extern Scene RadScene;               /* The scene */
extern HBBox Scene_BVH;              /* Scene hierarchical BV tree */
extern Object_List *objlist;         /* List of objects in front of
					plane of current shooter */
extern int objlist_size;
extern FF_OptionType FF_Options;

extern int Poly_Behind_Poly();

extern void StartIntersect();        /* Ray tracing routines */
extern void EndIntersect();
extern void Init_ShaftStats();

extern void InitHemicube();          /* Hemicube routines */
extern void InitSumFactors();
extern void SumFactors();
extern void FreeSumFactors();
extern void UpdateElementFactors();
extern void MakeTopFactors();
extern void MakeSideFactors();

extern void print_Polygon();         /* Print a polygon's info */
extern void print_View();            /* Print PR viewing parameters */
extern void Begin_DrawHC();          /* clear item buffer */
extern void End_DrawHC();            /* read frame buffer */
extern void Begin_DrawDispl();       /* clear display */
extern void End_DrawDispl();         /* swap buffers */
extern void Draw_Polygon();          /* draw polygon */
extern void Draw_PolygonRGB();       /* draw polygon RGB */
extern void CleanUpBuffers();        /* close buffers */
extern Spectra Pr_Ambient_Term();    /* ambient term for display */
extern void Save_Screen_Image();     /* Save image at end of PR */

extern void vcr_end_video();         /* Stop the video */

extern void LogConv();               /* Loggin convergence */
extern void LogConv_Pt();

extern Time_Stats tstats;            /* CPU time statistics */
extern FILE *rlogfile;               /* File of data points of convergence */

extern int num_inter;
extern int intermed[4];
extern int test_optik;
extern void Write_RadOptik();
