/**********************************************************************/
/*                                                                    */
/* outp.c :                                                           */
/*                                                                    */
/* Generalized output routines. Currently only Optik flat shaded      */
/* polygons are output.                                               */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include <string.h>
#include "geo.h"
#include "misc.h"
#include "io.h"
#include "struct.h"
#include "rad.h"

extern OptionType Option;
extern int test_optik;

Colour avg_c = { 0., 0., 0.};
/**********************************************************************/
/* Output results after running radiosity on scene in optik format    */
/**********************************************************************/
void Write_RadOptik(rparams, filename, num)
     RadParams rparams;
     char *filename;
     int num;
{
  int i,j;
  Elist *elptr;
  Polygon *eptr;
  FILE *fp;
  char ffilename[80];
  Colour c[MAX_PATCH_VTX];
  double Ks, Kd;

  if (num > 0) 
    sprintf(ffilename,"%s.opt%d", filename, num);
  else
    sprintf(ffilename,"%s.opt", filename);
  if (!(fp = fopen(ffilename, "w"))) {
    fprintf(stderr,"%s: cannot open results file %s\n", ProgName, ffilename);
    exit(1);
  } 
  printf("\n\t*** Printing %d polygons to %s ***\n", 
	 rparams.num_elements, ffilename);
  
  /* Print elements to file */
  fprintf(fp,"/* Number polygons %d\n", rparams.num_elements);
  elptr = rparams.elements;
  for(i=0; i<rparams.num_elements;i++, elptr = elptr->next) {
    eptr = elptr->element;

    /* Print patch label */
    (void) fprintf(fp,"add object P%d polygon\n", i);

    /* Print vertex / normal pairs */
    for (j=0;j<eptr->numVert;j++) {
      (void) fprintf(fp,"\tvertex ",i);
      (void) fprintf(fp,"\t%g %g %g ", eptr->vert[j]->pos.x, 
	      eptr->vert[j]->pos.y, eptr->vert[j]->pos.z);
      (void ) fprintf(fp,"%g %g %g\n",
	      eptr->normal[j].x, eptr->normal[j].y, eptr->normal[j].z);
    }
    (void) fprintf(fp,"end\n");

    /* Print colour of patch (flat shade it for now) */
    Ks = poly_object(eptr)->surface->shade.Ks.samples[0];
    Kd = poly_object(eptr)->surface->shade.Kd.samples[0];

    avg_c.r = 0.;    avg_c.g = 0.;    avg_c.b = 0.;
    if (Option.rad_interp_type == INTERP_VTX_FROM_PATCH) {
      /* Take flat value */
      avg_c.r = eptr->B.samples[0];
      avg_c.g = eptr->B.samples[1];
      avg_c.b = eptr->B.samples[2];
    } else {
      /* Take average colour of vertices */
      Poly_VertexB(eptr, c);
      for (j=0;j<eptr->numVert;j++) {
	avg_c.r += (c[j].r / (double) eptr->numVert);
	avg_c.g += (c[j].g / (double) eptr->numVert);
	avg_c.b += (c[j].b / (double) eptr->numVert);
	printf("avg=%g,%g,%g\n", avg_c.r, avg_c.g, avg_c.b);
      }
    }
    (void) fprintf(fp,"add surface PS%d ",i);
    avg_c.r *= (double) test_optik;
    avg_c.g *= (double) test_optik;
    avg_c.b *= (double) test_optik;
    (void) fprintf(fp,"%g %g %g 1 0.5 %g %g\n", 
		   (avg_c.r > 1.0 ? 1.0 : avg_c.r), 
		   (avg_c.g > 1.0 ? 1.0 : avg_c.g), 
		   (avg_c.b > 1.0 ? 1.0 : avg_c.b), 
		   Ks, Kd);

    (void) fprintf(fp, "surface P%d PS%d\n", i,i);
  }

  (void) fclose(fp);
}
