/**********************************************************************/
/* bvol.h                                                             */
/*                                                                    */
/* Structures for hierarchical bounding volumes                       */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef BVOL_H
#define BVOL_H

#define XX	0
#define YY	1
#define ZZ	2
#define LOW	0
#define HIGH	1

#define MAX_BV_CHILDREN 16     /* Keep the breadth of the tree small */
/* Is p outside of the bounding box b */
#define OutOfBounds(p,b) ((p)->x < b->min.x || (p)->x > b->max.x ||\
			  (p)->y < b->min.y || (p)->y > b->max.y||\
			  (p)->z < b->min.z || (p)->z > b->max.z)

/* For unlimited # of bounding volumes per bounding volume           */
/* (not used) -- if use replace "child" definition in HBBox          */
/* definition                                                        */
typedef struct HHBox_List  {   /* Bounding volumes in bounding volume*/
  struct HHBox *box;           /* bounding volume                    */
  struct HHBox_List *next;     /* Next bounding volume ptr           */
} HBBox_List;

typedef struct HBBox {         /* Hierarchical bounding volume node  */
  double area;                 /* Area of bounding volume            */
  BoundingBoxType *box;        /* bounding volume                    */
  Objectt *object;             /* Object if any contained in         */
			       /* bounding volume                    */
  Polygon *poly;               /* Polygon if any contained in BV     */
  struct HBBox *father;        /* Father bounding volume             */
  int num_children;            /* Number of volumes contained in
				  this node */
  struct HBBox                 /* List of "child" volumes contained  */
    *child[MAX_BV_CHILDREN];
  int level;                   /* Level in tree                      */
} HBBox;

typedef struct Object_List {   /* List of potential receivers        */
  HBBox *hbox;                 /* Object volume in list              */
  struct Object_List *next;    /* Next object ptr                    */
  int is_receiver;             /* Is a receiver from some source     */
  int is_obstructor;           /* Is possble obstructor of source from
				  receiver */
} Object_List;

#define UNCHANGED 0            /* Data ordering                      */
#define SHUFFLE 1
#define ALL_SPHERE 0           /* Bounding volume types              */
#define ALL_BOX 1
#define ALL_MIXED 2

typedef struct {               /* Bounding box options               */
  int input_order;             /* Shuffle, or leave (default) input 
				  data before building tree */
  int boxtype;                 /* is data homogenous (default)       */
} HBBox_OptionType;

/**********************************************************************/
extern double BVH_Cost_Box();
extern double BVH_Cost_Sphere();
extern double BVH_IncrementalCost_Box();
extern int IsLeafBox();
extern int BVH_Cull();

extern void Print_ObjectList();
extern void Init_ObjectList();
extern void AddTo_ObjectList();
extern void Make_ObjectList();

#endif /* BVOL_H */
