/*
 *  int is_polygon_convex(fp)
 *      FILE *fp;
 *
 *  This routine determines if the polygon determined by the points
 *  given by the stream fp is convex in O(n) time and O(1) space.  The
 *  polygon may be self-intersecting.  See below for return values and
 *  the definition of Data_type.
 *
 *  The program is based on the ideas of Peter Schorn
 *	(the original algorithm and the lexicographic ordering).
 *  The program was coded by Wayne Boucher.
 *  The program was bug-fixed, tested, etc., by Eric Haines.
 *
 *  20-21 October 1992
 */

#include <stdio.h>

/* the type of the data - change to "float" or whatever you use */
/* also change the format types in the "fscanf" below */
typedef double Data_type;

/* the possible return values */
#define  NOT_CONVEX  0
#define  CONVEX  1

/* the case NEITHER can easily occur if Data_type = int,
   not so easily if Data_type = float */
#define  NEITHER  0

/* the direction of an edge with respect to the lexicographic ordering  */
#define  INCREASING  1
#define  DECREASING  2

#define  DIRECTION \
(x1 > 0) ? INCREASING : (x1 < 0) ? DECREASING : \
(y1 > 0) ? INCREASING : (y1 < 0) ? DECREASING : NEITHER

/* the sense of the angle determined by two consecutive edges */
#define  CLOCKWISE  1
#define  COUNTER_CLOCKWISE  2

#define  ANGLE_SENSE \
((d = y1*x2 - x1*y2) > 0) ? CLOCKWISE : (d < 0) ? COUNTER_CLOCKWISE : NEITHER

/* whether or not the read has been successful */
#define  OK_READ  0
#define  NOT_OK_READ  1

#define  GET_NEXT_POINT(a, b) \
	(fscanf(fp, "%lf %lf", &a, &b) == 2  ?  OK_READ  :  NOT_OK_READ)

#define  CHECK_DIRECTION_AND_SENSE \
	switch (DIRECTION) \
	{ \
	    case INCREASING: \
	    	if (direction == DECREASING) \
		    if (++nchanges > 2)  return  NOT_CONVEX; \
	    	direction = INCREASING; \
		break; \
	    case DECREASING: \
	    	if (direction == INCREASING) \
		    if (++nchanges > 2)  return  NOT_CONVEX; \
	    	direction = DECREASING; \
		break; \
	} \
	switch (ANGLE_SENSE) \
	{ \
	    case CLOCKWISE: \
		if (sense == COUNTER_CLOCKWISE)  return  NOT_CONVEX; \
		sense = CLOCKWISE; \
		break; \
	    case COUNTER_CLOCKWISE: \
		if (sense == CLOCKWISE)  return  NOT_CONVEX; \
		sense = COUNTER_CLOCKWISE; \
		break; \
	}

int is_polygon_convex(fp)
    FILE *fp;
{
    int nchanges, direction, sense;
    Data_type a0, b0, a1, b1, a2, b2, a3, b3;
    Data_type x1, y1, x2, y2, d;


    if (GET_NEXT_POINT(a0, b0) != OK_READ)  return  CONVEX;
    if (GET_NEXT_POINT(a1, b1) != OK_READ)  return  CONVEX;
    if (GET_NEXT_POINT(a2, b2) != OK_READ)  return  CONVEX;

    x1 = a1 - a0;  y1 = b1 - b0;
    x2 = a2 - a1;  y2 = b2 - b1;

    direction = DIRECTION;
    sense = ANGLE_SENSE;

    nchanges = 0;
    while (GET_NEXT_POINT(a3, b3) == OK_READ)
    {
	x1 = x2;  y1 = y2;
	x2 = a3 - a2;  y2 = b3 - b2;

	CHECK_DIRECTION_AND_SENSE;

	a2 = a3;  b2 = b3;
    }

    x1 = x2;  y1 = y2;
    x2 = a0 - a2;  y2 = b0 - b2;

    CHECK_DIRECTION_AND_SENSE;

    x1 = x2;  y1 = y2;
    x2 = a1 - a0;  y2 = b1 - b0;

    CHECK_DIRECTION_AND_SENSE;

    return CONVEX;
}

#ifdef TEST

#define  ERROR_AND_EXIT(msg) \
	 {    fprintf(stderr, "Fatal error: %s\n", msg);  exit(1);   }

int main()
{
    int i, n;
    Data_type *x, *y;
    char file_name[80];
    FILE *fp;

/*
    printf("File name: ");
    scanf("%s", file_name);

    if ((fp = fopen(file_name, "r")) == NULL)
	ERROR_AND_EXIT("opening file");

    switch (is_polygon_convex(fp))
 */
    switch (is_polygon_convex(stdin))   /* KRS */
    {
	case CONVEX:
	    printf("polygon is convex\n");
            exit(0); 
	    break;   /* KRS */

	case NOT_CONVEX:
	    printf("polygon is not convex\n");
            exit(-1); 
	    break;   /* KRS */
    }

/*    fclose(fp); */  /* KRS */

    return  0;
}

#endif /* TEST */
