/* vrml.c - code to write a VRML file
 *
 * $Id: vrml.c,v 1.1 96/02/11 21:24:02 leech Exp $
 *
 * Copyright (C) 1996, Jonathan P. Leech
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is". Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Log:	vrml.c,v $
 * Revision 1.1  96/02/11  21:24:02  leech
 * Initial revision
 * 
 *
 */
#include "nnsort.h"
#include "SphereState.h"
#include "vrml.h"

#include <stdio.h>
#include <malloc.h>

boolean write_vrml(const char *file, SphereState *model)
{
    FILE *fp = fopen(file, "w");
    if (fp == NULL) {
	fprintf(stderr, "write_vrml: can't open file %s\n", file);
	return false;
    }

    int npt = model->GetNumBodies();
    if (npt < 4) {
	fprintf(stderr, "write_vrml: need >= 4 points to make convex hull\n");
	return false;
    }

    dvector *pt = new dvector[npt];
    for (int i = 0; i < npt; i++)
	pt[i] = model->GetPosition(unsigned(i));

    int (*facets)[3];
    int nf = nnhull3((double (*)[3])pt, npt, &facets);

    fprintf(fp, "#VRML V1.0 ascii\n");
    fprintf(fp, "Separator {\n");
    fprintf(fp, "\tMaterial {\n\t\tambientColor 1 1 1 diffuseColor 1 1 1\n\t}\n");

    fprintf(fp, "\tCoordinate3 {\n\t\tpoint [\n");
    for (i = 0; i < npt; i++)
	fprintf(fp, "\t\t\t%g %g %g,\n", pt[i][0], pt[i][1], pt[i][2]);
    fprintf(fp, "\t\t]\n\t}\n");

    fprintf(fp, "\tIndexedFaceSet {\n\t\tcoordIndex [\n");
    for (i = 0; i < nf; i++)
	fprintf(fp, "\t\t\t%d, %d, %d, -1,\n",
	    facets[i][0], facets[i][1], facets[i][2]);
    fprintf(fp, "\t\t]\n\t}\n");

    fprintf(fp, "}\n");
    fclose(fp);

    free((void *)facets);
    return true;
}
