C***********************************************************************
C
C  sfstubs.f
C
C  This file contains all the fortran stub routines.
C
C***********************************************************************

	subroutine plsdev(dnam)

	character*(*) dnam

        include "strings.f"

	call strf2c(dnam, string1, maxlen)
	call plsdev_(s1)

	end

C***********************************************************************

	subroutine plsfnam(fnam)

	character*(*) fnam

        include "strings.f"

	call strf2c(fnam, string1, maxlen)
	call plsfnam_(s1)

	end

C***********************************************************************

	subroutine plgfnam(fnam)

	character*(*) fnam

        include "strings.f"

	call plgfnam_(string1)
        call strc2f(string1, fnam)

	end

C***********************************************************************

	subroutine plgver(ver)

	character*(*) ver

        include "strings.f"

	call plgver_(s1)
        call strc2f(string1, ver)

	end

C***********************************************************************

	subroutine plaxes(x0,y0,xopt,xtick,nxsub,yopt,ytick,nysub)

	real	x0, y0, xtick, ytick
	integer nxsub, nysub
	character*(*) xopt,yopt

        include "strings.f"

	call strf2c(xopt, string1, maxlen)
	call strf2c(yopt, string2, maxlen)

	call plaxes_(x0,y0,s1,xtick,nxsub,s2,ytick,nysub)

	end

C***********************************************************************

	subroutine plbox(xopt,xtick,nxsub,yopt,ytick,nysub)

	real	xtick, ytick
	integer nxsub, nysub
	character*(*) xopt,yopt

        include "strings.f"

	call strf2c(xopt, string1, maxlen)
	call strf2c(yopt, string2, maxlen)

	call plbox_(s1,xtick,nxsub,s2,ytick,nysub)

	end

C***********************************************************************

	subroutine plbox3(xopt,xlabel,xtick,nxsub,yopt,ylabel,ytick,nysub,
     *		    zopt,zlabel,ztick,nzsub)

	real	xtick, ytick, ztick
	character*(*) xopt,xlabel,yopt,ylabel,zopt,zlabel
	integer nxsub, nysub, nzsub

        include "strings.f"

	call strf2c(xopt, string1, maxlen)
	call strf2c(xlabel, string2, maxlen)
	call strf2c(yopt, string3, maxlen)
	call strf2c(ylabel, string4, maxlen)
	call strf2c(zopt, string5, maxlen)
	call strf2c(zlabel, string6, maxlen)

	call plbox3_(s1,s2,xtick,nxsub,
     *               s3,s4,ytick,nysub,
     *               s5,s6,ztick,nzsub)

	end

C***********************************************************************

	subroutine plcon0(z,nx,ny,kx,lx,ky,ly,clevel,nlevel)
	call plcon0_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel)
	end

C***********************************************************************

	subroutine plcon1(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	call plcon1_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	end

C***********************************************************************

	subroutine plcon2(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	call plcon2_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	end

C***********************************************************************

	subroutine plcont(z,nx,ny,kx,lx,ky,ly,clevel,nlevel)

	real	z, clevel
	integer nx, ny, kx, lx, ky, ly, nlevel
	real tr
	common /plplot/ tr(6)

	call plcont_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,tr)

	end

C***********************************************************************

	subroutine pllab(xlab,ylab,title)

	character*(*) xlab,ylab,title

        include "strings.f"

	call strf2c(xlab, string1, maxlen)
	call strf2c(ylab, string2, maxlen)
	call strf2c(title, string3, maxlen)
	
	call pllab_(s1,s2,s3)

	end

C***********************************************************************

	subroutine plmtex(side,disp,pos,xjust,text)

	real	disp, pos, xjust
	character*(*) side, text

        include "strings.f"

	call strf2c(side, string1, maxlen)
	call strf2c(text, string2, maxlen)

	call plmtex_(s1,disp,pos,xjust,s2)

	end

C***********************************************************************

	subroutine plptex(x,y,dx,dy,xjust,text)

	real	x, y, dx, dy, xjust
	character*(*) text

        include "strings.f"

	call strf2c(text, string1, maxlen)

	call plptex_(x,y,dx,dy,xjust,s1)

	end

C***********************************************************************

	subroutine plstart(devname, nx, ny)

	character*(*) devname
	integer nx, ny

        include "strings.f"

	call strf2c(devname, string1, maxlen)

	call plstart_(s1, nx, ny)

	end

C***********************************************************************
