
#ifndef SYNTHESIS_FILTER_H
#define SYNTHESIS_FILTER_H

class SynthesisFilter {
  static const real d[512];
  static const real n[32][31];
  real v1[512], v2[512];
  real *actual_v;			// v1 or v2
  uint32 actual_write_pos;		// 0-15

  real	 samples[32];			// max. 32 new subband samples
  uint32 subbandnumbers[32];		// subbandnumbers of new samples
  uint32 number_of_samples;		// number of elements in samples[] and subbandnumbers[]

  uint32 channel;
  real	 scalefactor;
  uint32 range_violations;
  real	 max_violation;
  uint32 written_samples;

  void compute_new_v (real *);
  void compute_pcm_samples (Obuffer *);
 public:
	SynthesisFilter (uint32 channelnumber, real scalefactor = 32768.0);
	// the scalefactor scales the calculated float pcm samples to short values
	// (raw pcm samples are in [-1.0, 1.0], if no violations occur)

  void	input_sample (real sample, uint32 subbandnumber){
    samples[number_of_samples] = sample;
    subbandnumbers[number_of_samples++] = subbandnumber;
  };
  void	calculate_pcm_samples (Obuffer *);
	// calculate 32 PCM samples and put the into the Obuffer-object

  uint32 violations (void) { return range_violations; }
  real	 hardest_violation (void) { return max_violation; }
  uint32 recommended_scalefactor (void) { return (uint32)(32768.0 / max_violation); }
  real	 seconds_played (uint32 frequency){
    return (real)written_samples / (real)frequency;
  }
};

#endif
