/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include "global.h"
#include "errorhandle.h"
FILE* open_file();
STAT* read_stat();
STAT_param* init_stat_param();

int fdp[2];

int
  stat_main(S)
STAT_param* S;
{
  FILE* fdstat = NULL; /* stat data */
  FILE* fdgm   = NULL;   /* gnuplot macro */
  FILE* fdgd   = NULL;   /* gnuplot data */
  STAT* SD;
/*------------------ parameter evaluation ---------------------*/
  if(eval_stat_param(S)) return -1;
/*------------------ stat file open and read ---------------*/
  if((fdstat = open_file(S->stat_file_name,"r")) == NULL) return -1;
  if((SD = read_stat(fdstat,S->scope,S->atm_mode, S->start_frame,
           S->stat_num, S->kind_of_stat, S->priority)) == NULL) {
    return -1;
    close_file(fdstat);
  }
  close_file(fdstat);
/*------------------ stat file open and read ---------------*/
  if((fdgm = open_file(S->plot_macro_name,"w")) == NULL) return -1;
  if((fdgd = open_file(S->plot_data_name, "w")) == NULL) return -1;
  /*------ make plot data data file ------*/
  switch(S->kind_of_stat) {
    case 0: make_dist_data(fdgd,SD);
            make_dist_macro(fdgm,S,SD);
            break;
    case 1: make_gene_rec_data(fdgd,SD);
            make_gen_rec_macro(fdgm,S,SD);
            break;
    case 2: make_autocorr_data(fdgd,SD);
            make_autocorr_macro(fdgm,S,SD);
            break; 
    case 3: make_interarr_data(fdgd,SD);
            make_interarr_macro(fdgm,S,SD);
  }
  fclose(fdgm);
  fclose(fdgd);
  plot_execute(S->plot_macro_name);
  return 0;
}

int
  plot_execute(macro_name)
char* macro_name;
{
  int pid;
  /*------ pipe crete ------*/
  if(pipe(fdp)<0) {
    perror("pipe");
    exit(1);
  }
  /*------ forking ------*/
  if((pid = fork()) < 0) {
    perror("fork");
    exit(1);
  }
  /*------ forked process ------*/
  if(pid == 0) {
#ifndef DEBUG
    int fdnull = open("/dev/null",O_WRONLY);
    close(2);    dup(fdnull);
#endif
    close(0);    dup(fdp[0]);
    close(fdp[0]);
    close(fdp[1]);
    execlp("gnuplot","gnuplot",macro_name,NULL);
#ifndef DEBUG
    close(fdnull);
#endif
    exit(1);/* end of child process */
  }
  close(fdp[0]);
}

void
  pipe_send_msg()
{
  FILE* fd;
  if(fdp[1] == 0) return;
  fd = fdopen(fdp[1],"w");
  fprintf(fd,"send message to pipe\n");
  fclose(fd);
  close(fdp[1]);
}

int
  eval_stat_param(S)
STAT_param* S;
{
  /*------ file name evaluation ------*/
  if(strlen(S->stat_file_name)==0) {errnum = 53;return -1;}
  if(S->stat_file_name[strlen(S->stat_file_name)+1] == '/') 
    {errnum = 53;return -1;} /* when directory */
  /*------ kind of stat evaluation ------*/
  switch(S->kind_of_stat) {
    case 0: case 1: case 2: break;
    case 3: S->level = 2;break;  /* inter arr -> bit/MB */
    default: errnum = 50;return -1;
  }
  /*------ level to atm_mode & kind_of_stat conversion ------*/
  switch(S->level) {
    case 0: S->atm_mode = 0; S->scope = 0; break; /* Bit/Frame */
    case 1: S->atm_mode = 0; S->scope = 1; break; /* Bit/Slice */
    case 2: S->atm_mode = 0; S->scope = 2; break; /* Bit/MB    */
    case 3: S->atm_mode = 1; S->scope = 0; break; /* ATM/Frame */
    case 4: S->atm_mode = 1; S->scope = 1; break; /* ATM/Slice */
    default: errnum = 50;return -1;
  }
  /*------ numbere of frame evaluation ------*/
  if(S->start_frame < 1)           {errnum = 51;return -1;}
  if(S->stat_num <1)               {errnum = 52;return -1;}
  /*------ file name evaluation ------*/
  if(strlen(S->stat_file_name)==0) {errnum = 53;return -1;}
  if(S->stat_file_name[strlen(S->stat_file_name)-1] == '/') 
    {errnum = 53;return -1;} /* when directory */
  /*------ ps file evaluaiton ------*/
  if(S->ps_out == 1) {
    if(strlen(S->ps_file_name)==0) {errnum = 54;return -1;}
    if(S->ps_file_name[strlen(S->ps_file_name)+1] == '/') 
      {errnum = 54;return -1;} /* when directory */
  }
#ifdef DEBUG
  disp_stat_param(S);
  fprintf(stderr,"eveluation OK!\n");
#endif
  return 0;
}
