

/* 
          MORPHINE    -  a simple morphing program         Mark Hall
	                                                   foo@cs.rice.edu
	  January 9, 1992				   hall@siggraph.org


	  This program source has been released into the public domain


*/

#define MAIN 
#include "globals.h"


main(argc, argv)
int   argc;
char *argv[];
{
   char *version = "version 0.1  initial beta release January 9, 1992  mrh";
   int        i;
   FILE *fpout;
   XEvent     event;
   int dummy = 0;
   char fname[50];
   int n;
   int sxmin, sxmax, symin, symax;

   if (argc <2) 
   {
      fprintf(stderr, "calling sequence is   %s <filename>", argv[0]);
      exit(0);
   }


   /* read the topography from files: 
           beginning texture
	   ending texture
	   background texture
	   meshes  (start and end for each texture above) 
    */
   readmeshes(argv[1]);

   /* read the textures */
   LoadGIF (starttexfile, &startingpic);   /* create or read the input image */
   LoadGIF (endtexfile, &endingpic);     /* create or read the input image */
   LoadGIF (backtexfile, &backgroundpic);/* create or read the input image */
   fprintf(stderr, "done reading gifs\n");

   copypic(&backgroundpic, &outputpic);   /* start with the background pic */


   /* pop up an X window */
   sxmax = symax = GGWIN.x0 = GGWIN.y0 = 0 ;           /* GGWIN stuff is from graphics gems */
   sxmin = GGWIN.x1 = backgroundpic.wide;      /* code that actually draws triangles */
   symin = GGWIN.y1 = backgroundpic.high;
   eWIDE = backgroundpic.wide;
   eHIGH = backgroundpic.high;
   CREWIN(&dummy, &dummy, &eWIDE, &eHIGH);  /* create the window */


   theImage = XCreateImage(theDisp,theVisual,8,ZPixmap,0,outputpic.data,
                           backgroundpic.wide,backgroundpic.high,8,
			   backgroundpic.wide);
   if (!theImage) FatalError("unable to create XImage");


   SetArbitraryColorMap(theDisp, theCmap, pixels, 256, glcolor);


   /* need this!!! to really draw the window */
   Resize(eWIDE,eHIGH);
   XMapWindow(theDisp,mainW);

   /* draw the original background picture on the screen */
   copypictowin(backgroundpic); /* start with the background pic */
   DrawWindow(0,0,backgroundpic.wide,backgroundpic.high);/* draw to screen*/

   /* we will keep track of how  much of the background we may have 
      overwritten at each step, so we can redraw only the needed part */
   redrawxmin = backgroundpic.wide-1;
   redrawymin = backgroundpic.high-1;
   redrawxmax = redrawymax = 0;

   /* draw the initial scene part */
   for (n=0; n<nummesh; n++)
   {
      warp(0, numsteps, n, beginmesh, endmesh, outmesh, 
	   &startingpic, &endingpic, &outputpic);
   }

   /* sxmin, sxmax, etc. remember the previously overwritten area */
   if (sxmin > redrawxmin) sxmin = redrawxmin;
   if (sxmax < redrawxmax) sxmax = redrawxmax;
   if (symin > redrawymin) symin = redrawymin;
   if (symax < redrawymax) symax = redrawymax;
   
   /* output changed parts to screen */
   DrawWindow(sxmin, symin, sxmax, symax); 

   if (OUTPUTGIFS)
   {
      sprintf(fname, "%s%d", outgiffilename, 0);
      fpout = fopen(fname, "w");
      WriteGIF(fpout, outputpic.data, outputpic.wide, outputpic.high, 
	       outputpic.cmap[0], outputpic.cmap[1], outputpic.cmap[2], 
	       outputpic.numcolors, 1); 
      fclose(fpout);
   }

   while (1) 
   {
      
      XNextEvent(theDisp, &event);
      if (event.type == ButtonPress) 
      {
	 
	 for (i=1; i<=numsteps; i++ )
	 {
	    
	    /*redraw background on outputpic for needed parts */
	    copypartpicdata(&backgroundpic, &outputpic, redrawxmin, redrawymin, 
			    redrawxmax, redrawymax);
	    copycmaplimit(&backgroundpic, &outputpic);

	    sxmin = redrawxmin;
	    sxmax = redrawxmax;
	    symin = redrawymin;
	    symax = redrawymax;
	    
	    redrawxmin = backgroundpic.wide-1;
	    redrawymin = backgroundpic.high-1;
	    redrawxmax = redrawymax = 0;
	    
	    /* draw the transformed part */
	    for (n=0; n<nummesh; n++)
	    {
	       warp(i, numsteps, n, beginmesh, endmesh, outmesh, 
		    &startingpic, &endingpic, &outputpic);
	    }
	    
	    if (sxmin > redrawxmin) sxmin = redrawxmin;
	    if (sxmax < redrawxmax) sxmax = redrawxmax;
	    if (symin > redrawymin) symin = redrawymin;
	    if (symax < redrawymax) symax = redrawymax;
	    
	    /* output changed parts to screen */
	    DrawWindow(sxmin, symin, sxmax, symax); 
	    

	    /* may have to update the colormap if the cmap size was 
	       increased by morphing 
	       THIS MAKES MY SCREEN FLICKER
	    */
	    if (outputpic.originalnumcolors != outputpic.numcolors)
	    {
	       /*fprintf(stderr, "numcolors=%d orig=%d\n", 
		       outputpic.numcolors, outputpic.originalnumcolors);*/
	       copypicmaptoglobal(&outputpic);
	       SetArbitraryColorMap(theDisp, theCmap, pixels, 256, glcolor);
	    }
	    XFlush(theDisp);

	    if (OUTPUTGIFS)
	    {
	       
	       sprintf(fname, "%s%d", outgiffilename, i);
	       fpout = fopen(fname, "w");
	       WriteGIF(fpout, outputpic.data, outputpic.wide, outputpic.high, 
			outputpic.cmap[0], outputpic.cmap[1],outputpic.cmap[2],
			outputpic.numcolors, 1); 
	       fclose(fpout);
	    }
	    
	 }


      }
      else HandleEvent(&event);
      
   }

}

