/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/TimeLine/RCS/dim.c,v 1.11 91/10/05 18:33:25 chua Exp Locker: drapeau $ */
/* $Log:	dim.c,v $
 * Revision 1.11  91/10/05  18:33:25  chua
 * Changed the name Unmute application to Remove mute from application.
 * 
 * Revision 1.0  91/09/30  16:53:31  chua
 * Update to version 1.0
 * 
 * Dim the new entry in the Options menu (Connect with new Port Manager ...)
 * 
 * Revision 0.70  91/09/26  17:59:20  chua
 * Added the menu items Mute application and Unmute application to the list to
 * be dimmed.
 * 
 * Revision 0.69  91/09/25  13:47:01  chua
 * Changed the instrument field, instInfo, to editInfo.
 * 
 * Revision 0.68  91/09/23  17:07:28  chua
 * The stop menu button has been removed.  Dim the new pause and stop buttons
 * when in stop mode.
 * 
 * Revision 0.67  91/09/19  17:28:41  chua
 * Make sure that variables are initialized properly.  Change formatting slightly,
 * so that (if, for, while) statements with only one statement in them will not have
 * braces.
 * 
 * Revision 0.66  91/09/04  15:08:16  chua
 * Changed the rcsid from menurcsid to dimrcsid.
 * 
 * Revision 0.65  91/08/13  15:02:06  chua
 * Do not dim the quit button at any time.
 * 
 * Revision 0.64  91/08/13  14:55:10  chua
 * Added dimming for some new items in the Document and Edit menu (didn't do it 
 * previously).
 * 
 * Revision 0.63  91/08/05  13:01:42  chua
 * Dim the move canvas buttons as well as the panel list and buttons in the region info popup 
 * window.
 * 
 * Revision 0.62  91/08/02  14:28:21  chua
 * Ignore the last RCS message.  The new change is dimming the buttons of the region info
 * panel when playing.
 * 
 * Revision 0.60  91/07/24  10:53:50  chua
 * Dim the notes and pause markers info lists as well during playing.
 * 
 * Revision 0.59  91/07/24  10:32:09  chua
 * Dim the buttons in the Pause popup window as well.
 * 
 * Revision 0.58  91/07/22  15:16:13  chua
 * Changed the name of the pointer to the blank time popup window to InsertBlankTimePopup,
 * instead of a longer name previously.
 * 
 * Revision 0.57  91/06/25  16:31:26  chua
 * Added code to dim the new menu functions.  These are:
 * - Hide Application
 * - Show Application
 * 
 * The above are under the Applications button.
 * 
 * Under the Stop menu button, there are the functions Stop and Pause.
 * These are dimmed when in stop mode and undimmed when in play mode.
 * 
 * The zoom slider is also dimmed during play mode.
 * 
 * Revision 0.56  91/06/04  17:37:11  chua
 * Added the copyright comments in the beginning of the file.
 * 
 * Revision 0.55  91/06/04  17:21:11  chua
 * In the DimButtons routine, add several if-statements to test if certain menu functions
 * are to be undimmed. These functions should not be undimmed if the frame is a Clipboard,
 * as they are permanently disabled for the clipboard, such as the edit functions.
 * 
 * This file used to be menu.c, but changed to dim.c now.
 * 
 * Revision 0.54  91/06/03  11:11:55  chua
 * Make changes to accomodate multiple documents.  This involves identifying
 * which is the current active window, that is, the one where the last mouse
 * click was done.
 * 
 * Revision 0.53  91/05/29  14:37:38  chua
 * *** empty log message ***
 * 
 * Revision 0.52  91/05/29  14:36:01  chua
 * This file contains the DimButtons procedure, which is called when starting or stopping play of
 * the timeline.  It does the dimming and undimming of the buttons depending on what mode the
 * timeline is currently in.
 *  */

static char dimrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/dim.c,v 1.11 91/10/05 18:33:25 chua Exp Locker: drapeau $";

#include "main.h"

/*
 * Function to dim or undim all buttons except the stop button when playing is in progress or when stop is pressed.
 * For the stop button, it is dimmed when in Stop mode, and undimmed when playing is in progress.
 * The parameter dim determines if dimming or undimming is to be done.
 * For some of the menu items, if the calling frame is the clipboard, undimming is not done since these menu functions are permanently
 * disabled.  The functions are those within the if-statements.
 * Called by TimeLineInit (TimeLine.c)
 */
void DimButtons(dim, tlFrame)
     int dim;
     TimeLineFramePtr tlFrame;
{
  Menu menu;
  Menu_item mi;
  int whichFrame;
  Instrument *instrument;
  
  whichFrame = xv_get(tlFrame->TimeLine_window->controls, PANEL_CLIENT_DATA);
  menu = xv_get(tlFrame->TimeLine_window->documentButton, PANEL_ITEM_MENU);
  if (whichFrame != 0 || dim) 
  {
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "New ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Open ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Save",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Save as ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Close",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
  }
  xv_set(tlFrame->TimeLine_window->documentButton, PANEL_INACTIVE, dim, NULL);
  
  menu = xv_get(tlFrame->TimeLine_window->appButton, PANEL_ITEM_MENU);
  if (whichFrame != 0 || dim) 
  {
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Update Applications List",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Delete selected application",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
  }
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Show edit info for an application ...",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Show application",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Hide application",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Mute application",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Remove mute from application",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  xv_set(tlFrame->TimeLine_window->appButton, PANEL_INACTIVE, dim, NULL);

  menu = xv_get(tlFrame->TimeLine_window->editButton, PANEL_ITEM_MENU);
  if (whichFrame != 0 || dim) 
  {
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Cut",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Copy",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Paste",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Delete",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Clear All",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Show Clipboard ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    xv_set(tlFrame->TimeLine_window->editButton, PANEL_INACTIVE, dim, NULL);
  }
  menu = xv_get(tlFrame->TimeLine_window->optionsButton, PANEL_ITEM_MENU);
  if (whichFrame != 0 || dim) 
  {
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Show Region Info ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Insert Blank Time ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Insert/Delete Pause Marker ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Grid",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    mi = (Menu_item) xv_find (menu, MENUITEM,
			      MENU_STRING, "Connect with new Port Manager ...",
			      NULL);
    xv_set(mi, MENU_INACTIVE, dim, NULL);
    xv_set(tlFrame->TimeLine_window->optionsButton, PANEL_INACTIVE, dim, NULL);
  }
  menu = xv_get(tlFrame->TimeLine_window->playButton, PANEL_ITEM_MENU);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Play whole document",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Play from insertion point",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Play selected area",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  xv_set(tlFrame->TimeLine_window->playButton, PANEL_INACTIVE, dim, NULL);
  xv_set(tlFrame->TimeLine_window->ZoomSlider, PANEL_INACTIVE, dim, NULL); /* Make the slider inactive */
  xv_set(tlFrame->TimeLine_window->MoveCanvasLeftButton, PANEL_INACTIVE, dim, NULL); /* Make the canvas buttons inactive */
  xv_set(tlFrame->TimeLine_window->MoveCanvasRightButton, PANEL_INACTIVE, dim, NULL); 
  xv_set(tlFrame->TimeLine_window->MoveCanvasFastLeftButton, PANEL_INACTIVE, dim, NULL); 
  xv_set(tlFrame->TimeLine_window->MoveCanvasFastRightButton, PANEL_INACTIVE, dim, NULL); 
  xv_set(tlFrame->TimeLine_window->ResetCanvasButton, PANEL_INACTIVE, dim, NULL); 
  if (whichFrame != 0 || dim) 
  {
    instrument = tlFrame->instHead;				    /* Deactivate all the notes info panel list */
    while (instrument != NULL) 
    {
      xv_set(instrument->editInfo->NoteInfoList, PANEL_INACTIVE, dim, NULL);
      instrument = instrument->next;
    }
    xv_set(tlFrame->InsertBlankTimePopup->InsertBlankTimeButton, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->PausePopup->PauseList, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->PausePopup->InsertPauseButton, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->PausePopup->DeletePauseButton, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->PausePopup->ClearAllPauseButton, PANEL_INACTIVE, dim, NULL);
    
    xv_set(tlFrame->RegionPopup->RegionList, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->RegionPopup->InsertRegionButton, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->RegionPopup->DeleteRegionButton, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->RegionPopup->ModifyRegionButton, PANEL_INACTIVE, dim, NULL);
    xv_set(tlFrame->RegionPopup->ClearAllRegionButton, PANEL_INACTIVE, dim, NULL);
  }
  if (dim == TRUE)						    /* Reverse the dim parameter for the stop and pause buttons */
    dim = FALSE;
  else 
    dim = TRUE;
  xv_set(tlFrame->TimeLine_window->pauseButton, PANEL_INACTIVE, dim, NULL);
  xv_set(tlFrame->TimeLine_window->stopButton, PANEL_INACTIVE, dim, NULL);
}

