/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/QuoteMaker/RCS/linkProtocol.c,v 2.17 92/09/25 14:33:36 drapeau Exp $ */
/* $Log:	linkProtocol.c,v $
 * Revision 2.17  92/09/25  14:33:36  drapeau
 * Fixed errors in the way the quoted text window was being located.  The
 * earlier version used the XView attributes "XV_WIDTH", "XV_HEIGHT", "XV_X",
 * and "XV_Y".  This version now uses the more proper "frame_get_rect()" and
 * "frame_set_rect()" functions for window placement and sizing.
 * Also, some cosmetic changes were made to enhance readability and ANSI
 * compliance.
 * 
 * Revision 2.16  92/09/12  18:43:38  drapeau
 * Replaced non-portable "irint()" function with simple cast-to-integer syntax.
 * 
 * Revision 2.15  92/05/29  12:41:27  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 2.14  92/05/14  15:41:28  drapeau
 * * Updated copyright information.
 * * Other formatting changes to conform to coding standards.
 * 
 * Revision 2.13  92/01/11  01:43:13  drapeau
 * Removed redeclarations of string functions since OpenWindows 2.0
 * headers don't seem to like them (OpenWindows 3.0 seemed to need
 * them).
 * 
 * Revision 2.12  92/01/09  18:25:25  drapeau
 * Slight modifications to make code ANSI-compliant.
 * 
 * Revision 2.11  91/12/31  18:43:21  drapeau
 * Removed the inclusion of string.h, since XView will include the
 * appropriate definitions.
 * 
 * Revision 2.1  91/09/30  15:32:48  derek
 * Changed ShowApplication().
 * 
 * Revision 2.0  91/09/30  15:02:36  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.51  91/09/24  14:47:33  derek
 * In HaltSelection(), I have added a statement checking for 
 * HideQTWAfterPlayingEdit, and QuoteMaker will take the quote window
 * off if this is true.
 * 
 * Revision 1.50  91/09/15  20:06:28  derek
 * The following things are done:
 * 1.      The foreground of mainTextPane and Quote Window are set to be black.
 *         Also, the color of all the text fields are set to black.
 * 2.      Now the quoted text will be shown directly on the Quote Window
 *         when a panel-item selection is made.  The text will also be shown
 *         while the author is highlighting a selection in the text window.
 * 3.      The inconsistency problem regarding text selection is being taken
 *         care of.  When the mouse cursor re-enters the text window,
 *         the selection will be highlighted again.
 * 4.      When the play button is pressed, the text currently selected
 *         in the text window (rather than the text initially associated
 *         with the edit) will be displayed.
 * 5.      The name of the menu_option "Show Quote Window Specifications panel"
 *         is shortened to be "Quote Window Options ..."
 * 6.      A notify_interpose_destroy_func() is being added to fix the bug
 *         that QuoteMaker might exit without killing the Quote Window (which
 *         is also a base window).
 * 7.      When a different font family or font style is selected, the change
 *         will be automatically be reflected on the Quote Window (without the
 *         need to "play" the edit in order to verify the font).  For font
 *         size, the change will be reflected when either a return character is
 *         entered at the text field or when one of those numeric "arrows"
 *         are pressed.
 * 8.      The play button will now flash when an edit is being played.
 *         Pause button will also glow when playing is paused.
 * 9.      In the course of playing, when another edit is selected,
 *         the playing will be stopped.
 * 10.     I have used Saber to clean up the code.
 * 11.     The left-over "NewEditListPopUp" window is removed.
 * 12.     The bug that when quote window is iconified, it wont be un-iconified
 *         when the edit is played in timeline, is fixed.
 * 13.     The DurationEstimate function is changed so that it no longer
 *         needs an edit to be selected first.  It will take textWindowStart
 *         and textWindowEnd directly as input parameters.
 * 
 * 
 * 
 * Revision 1.49  91/09/05  15:48:02  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.48  91/08/27  14:37:36  derek
 * The following things are done:
 * 1.	The QuotedTextWindow is changed from a base window to a popup window
 * 	(now it's called QuotedMaker_quotedTextBaseWindow).  I have also
 * 	added a few options: show, hide and iconify QTW and also created
 * 	an icon for QTW.
 * 2.	The quoted text will be set in PerformSelection() instead of 
 * 	in SetSelection().
 * 3.	I have changed the Document field and the EditList field of 
 * 	QuoteMaker so that they will display fill paths.
 * 
 * Revision 1.47  91/08/26  12:10:19  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.46  91/07/15  12:20:04  derek
 * 1.      I have added font selection panel to the application.
 *         Now a user can specify a font by choosing a font family, a font
 *         style and font size.
 * 2.      Location and size fields are added to the application.  User
 *         can specify the size and location of the QuotedTextWindow.
 * 3.      A duration estimate button is added to estimate how long the
 *         the quoted text should last.
 * 4.      Interface has been redesigned to accomodate the addition of
 *         font, size and location functionalities.
 * 6.      EditList file format has been changed to accomodate the new
 *         fields.  They are:  location (x,y), width, height, font family,
 *         font style, font width for QuotedTextWindow.
 * 5.      Two timers have been added in an attempt to ensure accuracy
 *         of gauge-updating in the preview panel.
 * 6.      Command line args are now supported.
 * 7.      I have cleaned up the code by using saber.
 * 8.      Several bugs from previous revision are fixed.
 * 
 * 
 * Revision 1.45  91/07/02  15:07:54  derek
 * QuoteMaker now fully speaks the new MAEstro protocol.
 * 
 * Revision 1.44  91/07/01  18:51:30  derek
 * The following things are done:
 * 1.	The interface is redesigned.  Duration fields are added to each 
 * 	edit list.
 * 2.	The function panel (functions Window) is implemented.  The 
 * 	application is now capable of being "played", "stopped" and
 * 	"paused".  The sense of "time" is now complete.
 * 3.	Makefile fixed.  
 * 4.	Declaration errors left by previous author are cleaned up.
 * 5.	Redundant malloc statements removed.   Certain other
 * 	functions are changed to improve code efficiency.
 * 6.	Code cleaned up by saber.  Removed redundant
 * 	variables.
 * 
 * Revision 1.43  91/06/28  13:16:02  derek
 * Blank functions added to the code to make the application "compatible"
 * with the new protocol.
 * 
 * Revision 1.42  91/06/27  18:21:18  derek
 * I have cleaned up some of the comments.  No change in code.
 * 
 * Revision 1.41  91/06/19  17:44:59  drapeau
 * No changes; changing RCS revision numbers.
 * 
 * Revision 1.4  91/02/27  03:53:45  drapeau
 * Modified SetSelection() so that the Quoted Text Popup window 'forgets' about
 * previous edits made to it.  This is done to prevent the XView toolkit from
 * bringing up "Unsaved changes made -- do you wish to discard?" messages.
 * These messages are unnecessary for the Quoted Text Popup, since it is meant
 * purely as a display window and not for editing purposes.
 * 
 * Revision 1.3  91/01/05  00:48:35  drapeau
 * Modified SetSelection() so that strings to be placed in the quoted text
 * window are always NULL-terminated.
 * 
 * Revision 1.2  90/12/05  19:22:25  drapeau
 * -- Modified OpenDoc() so that it does not needlessly open edit lists.  a
 *    static variable keeps track of the last document opened; if the current
 *    request is for the same document that the last request sent, the edit
 *    list is not re-opened (since it's already opened).
 * -- Modified OpenDoc() to check for valid filenames being opened.
 * -- Modified SetSelection() to check for invalid selections being requested;
 *    for example, if only 5 items are in the current editList but item #8 is
 *    being requested from the network.
 * 
 * Revision 1.1  90/12/04  17:21:51  drapeau
 * Initial revision
 *  */

static char rcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/linkProtocol.c,v 2.17 92/09/25 14:33:36 drapeau Exp $";

/*
 * QuoteMaker.c - Notify and event callback function stubs.
 * This file was copied from "QuoteMaker_stubs.c", which was
 * generated by `gxv' from `QuoteMaker.G'.
 * Modified by George Drapeau on October 26, 1990.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "QuoteMaker_ui.h"
#include <sys/stat.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/server.h>          
#include <xview/seln.h>            
#include "Sender.h"
#include "Receiver.h"
#include "quoteMakerDefs.h"


double   SelectionDuration;
char*    selectedText;



/*--------------------------------------------------------------------------------
  Link Protocol functions
  */




void OpenDoc(editListName)
     char**	editListName;
{
  int		result;
  struct stat	fileInfo;
  static char*	lastDocOpened = "Untitled";
  
  EVENT("Open_Doc");

  if (*editListName == NULL)					    /* Is an invalid document name being requested? */
  {
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"Error:  edit-list name is NULL");
    return;							    /* Yes, return without doing anymore work */
  }
  
  if (!strcmp(ShortName(*editListName), "NoneSpecified"))	    /* Was the document passed in a valid name? */
  {
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"Error:  'NoneSpecified' is not a valid edit-list name.");
    return;							    /* No, "NoneSpecified" is not a valid name; leave */
  }

  if (!strcmp(*editListName, lastDocOpened))			    /* Is the document the same as the last time... */
    return;							    /* ...function was called?  If so, do nothing. */
  lastDocOpened = (char*)strdup(*editListName);			    /* Update last document opened */

  result = stat(*editListName,&fileInfo);			    /* Attempt to get info about the specified file */
  if ((result == 0) && (!(fileInfo.st_mode & S_IFDIR)))		    /* Does  file exist (... is it *not* a directory)? */
  {
    ReadEditListFromFile(*editListName, LINK_EDITOR);		    /* Yes, the file exists.  Open it and read it in */
    PreloadFontsOntoQTW();
  }
  else
  {
    sprintf(msg, "Error:  Cannot access edit-list file '%s'",
	    editListName);
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			msg);
  }
}
  



void SetSelection(MAESelection*	selection)
{
  int			entryNum, start, length, count;
  char*			tempPointer;
  extern double		currentTime;
  char*			index();
  
  EVENT("Set_Selection");
  if (selection->start >= editList.numItems)			    /* Check for selection requested not on edit list...*/
  {								    /* ...ie. edit list has 5 items and request is... */
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"Error: edit number is bigger than the number of items in the list.");
    return;
  }
  
  currentTime = selection->offset /1000.0;			    /* Set offset to current time. */
  entryNum = selection->start;
  if (mostRecentEditNum != NO_CURRENT_EDIT)			    /* Is this the 1st time a selection is being made? */
  {								    /* Yes, don't try to deselect something that... */
    UnHighlightSelection();					    /* ...hasn't been selected yet. */
    DeselectList();
  }								    /* end if (mostRecentEditNum... */
  xv_set(QuoteMaker_baseWindow->editListScrolledList,		    /* Highlight the corresponding item in the...       */
	 PANEL_LIST_SELECT, entryNum, TRUE, NULL);		    /* ...panel-list.                                   */
  
  SetCurrentSelection(entryNum);				    /* This also positions the quoted text window */
  start = editList.start[entryNum];				    /* Get start and end points for the selection.  */
  SelectionDuration = editList.duration[entryNum];
  
  length = editList.end[entryNum] - start + 1;			    /* Calculate size of text to be selected */
  selectedText = (char *) malloc(length + 1);			    /* Allocate space for the text to be selected */
  xv_get(QuoteMaker_textWindowPopup->mainTextPane,		    /* Get the text to be selected */
	 TEXTSW_CONTENTS, start, selectedText, length);
  selectedText[length] = '\0';					    /* Make sure selected text is NULL-terminated */
  for (tempPointer = selectedText, count=0;			    /* Go through selected text, looking for newlines... */
       tempPointer;						    /* ...and replace each newline with a space. */
       tempPointer = index(tempPointer, '\n'), count++)
  {
    if (tempPointer != selectedText)				    /* Is "tempPointer" pointing to start of the buffer? */
      tempPointer[0] = ' ';					    /* No, must be pointing to a newline; replace with space... */
    if (count > 100)						    /* If this loop has replaced a large number of ... */
      break;							    /* ...lines, exit loop; chances are the end... */
  }								    /* ...won't be saved anyway. */
  OldLocX = editList.locX[entryNum];				    /* These statements are added to ensure that the... */
  OldLocY = editList.locY[entryNum];				    /* ...old size and location values are updated so.. */
  OldSizeWidth = editList.sizeWidth[entryNum];			    /* ...that the "modify bit" wont be updated by...   */
  OldSizeHeight = editList.sizeHeight[entryNum];		    /* ...the notify_interposer.                        */
  
  SetQuotedTextWindowLocation(editList.locX[entryNum],
			      editList.locY[entryNum]);
  SetQuotedTextWindowSize(editList.sizeWidth[entryNum],
			  editList.sizeHeight[entryNum]);
  SetQuotedTextWindowFont(editList.fontFamily[entryNum],
			  editList.fontStyle[entryNum],
			  editList.fontSize[entryNum]);
  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /* Allow the Quoted Text popup window to be edited */
	 TEXTSW_BROWSING, FALSE , NULL);
  
  length = xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextPane,  /* Get the number of characters currently in the... */
		  TEXTSW_LENGTH);				    /* ...popup win. */
  if (length > 0)
    textsw_delete(QuoteMaker_quotedTextBaseWindow->quotedTextPane,  /* Erase any previously shown text in the Text... */
		  0, length);					    /* popup window. */
  
  textsw_reset(QuoteMaker_quotedTextBaseWindow->quotedTextPane,0,0); /* Pretend that the QTW was never modified */
  
  Hide(&QuoteMaker_textWindowPopup->textWindowPopup);
  
  return;
}								    /* end function SetSelection */



void PerformSelection()
{
  EVENT("Perform_Selection");

  Playing = TRUE;

  if (xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow, /*  If the quote window is iconified, un-iconify... */
	     FRAME_CLOSED) == TRUE)				    /*  ...it.                                          */
  {
    xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	   FRAME_CLOSED, FALSE, NULL);
  }
  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	 XV_SHOW, TRUE, NULL);

  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /*  Put the selected text into the quoted Text...   */
	 TEXTSW_CONTENTS, selectedText, NULL);			    /*  ...popup window.                                */

  
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,	    /*  Allow the Quoted Text popup window to be...     */
	 TEXTSW_BROWSING, TRUE, NULL);				    /*  ...edited.                                      */
  
  textsw_normalize_view(QuoteMaker_quotedTextBaseWindow->quotedTextPane,
			0);					    /*  Make sure quoted text shows up at top of...     */
								    /*  ...popup window.                                */
  AlertStatus("Playing ...");

  SetButtonGlowTimer(GLOW_INTERVAL);

  SetTimer(SelectionDuration);
}								    /* end function PerformSelection */




char** GetDoc()
{
  static char   *returnValue;
  
  EVENT("Get_Doc");

  if (strlen(absoluteEditListName) == 0 ||
      strcmp(absoluteEditListName, "untitled") == 0 ||
      strcmp(absoluteEditListName, "NoneSpecified") == 0)
  {
    returnValue = (char *)strdup("untitled");
  }
  else
  {
    returnValue = absoluteEditListName;
  }

  return(&returnValue);
}





MAESelection* GetSelection(unusedArg)
     void*	unusedArg;
{
  static MAESelection select;
  
  EVENT("Get_Selection");
  
  if (mostRecentEditNum == NO_CURRENT_EDIT)			    /*  Return select.duration = -1 if there is no...   */
  {								    /*  ...current Selection.                           */
    select.duration = -1;
    return(&select);
  }

  select.start = mostRecentEditNum;
  select.end = mostRecentEditNum;
  select.offset = 0;
  select.duration = (int)(editList.duration[mostRecentEditNum] * 1000.0);
  
  if (strlen(editList.label[mostRecentEditNum]) == 0)
  {
    strcpy(select.label, "No Label");
  }
  else
  {
    strcpy(select.label, editList.label[mostRecentEditNum]);
  }

  return (&select);
}



void
  HaltSelection(MAESelection* selection)
{
  CancelTimer();
  CancelButtonGlowTimer();
  CancelButtonGlow();
  ClearStatusMessage();
  ClearQuotedTextWindow();

  if (HideQTWAfterPlayingEdit)
  {
    xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	   XV_SHOW, FALSE,
	   NULL);
  }
  
  PlayPaused = FALSE;
  Playing = FALSE;
}


void
  PauseSelection()
{
  PauseButtonHandler(NULL, NULL);
}


void
  ResumeSelection()
{
  PauseButtonHandler(NULL, NULL);
}


void
  HideApplication()
{
  xv_set(QuoteMaker_baseWindow->baseWindow, FRAME_CLOSED, TRUE, NULL);
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow, FRAME_CLOSED,
	 TRUE, NULL);
  XFlush((Display *) xv_get(QuoteMaker_baseWindow->baseWindow, 
			    XV_DISPLAY));
}


void
  ShowApplication()
{
  xv_set(QuoteMaker_baseWindow->baseWindow, FRAME_CLOSED, FALSE, NULL);
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,FRAME_CLOSED, FALSE, NULL);
  if (xv_get(QuoteMaker_infoPopup->infoPopup, XV_SHOW) == TRUE)
  {
    xv_set(QuoteMaker_infoPopup->infoPopup, XV_SHOW, TRUE, NULL);
  }
  if (xv_get(QuoteMaker_textWindowPopup->textWindowPopup, XV_SHOW) == TRUE)
  {
    xv_set(QuoteMaker_textWindowPopup->textWindowPopup, XV_SHOW, TRUE, NULL);
  }
  if (xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->QuoteWindowSpecificationsPopup,
	     XV_SHOW) == TRUE)
  {
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->QuoteWindowSpecificationsPopup,
	   XV_SHOW, TRUE, NULL);
  }
  XRaiseWindow((Display *)xv_get(QuoteMaker_baseWindow->baseWindow, XV_DISPLAY),
	       (Window) xv_get(QuoteMaker_baseWindow->baseWindow, XV_XID));
  
  XRaiseWindow((Display *)xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow, XV_DISPLAY),
	       (Window) xv_get(QuoteMaker_baseWindow->baseWindow, XV_XID));
  XFlush((Display *) xv_get(QuoteMaker_baseWindow->baseWindow, 
			    XV_DISPLAY));
  XFlush((Display *) xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
			    XV_DISPLAY));
}


IconData *
  GetAppIcon()
{
  static IconData returnVal;
  static unsigned short baseWindow_bits[] = {
#include "icons/QuoteMaker.icon"
        };

  returnVal.iconData = (char *)malloc(sizeof(baseWindow_bits));
  bcopy(baseWindow_bits, returnVal.iconData, sizeof(baseWindow_bits));

  if (returnVal.iconData)
    returnVal.dataLength = sizeof(baseWindow_bits);

  return(&returnVal);
}
