/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*$Header: /Source/Media/collab/DTR/RCS/network.c,v 1.12 92/05/29 12:42:16 drapeau Exp $*/
/* $log$ */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/network.c,v 1.12 92/05/29 12:42:16 drapeau Exp $";

#include "dtr.h"
#include "dtr_ui.h"
#include <getopt.h>

extern  dtr_editListPanelPopUp_objects*	dtr_editListPanelPopUp;
extern dtr_mainWindow_objects*		dtr_mainWindow;

char  oldFileName[MAXPATHLEN];


void CheckOptions(argc, argv)
     int 	argc;
     char 	**argv;
{
  int optionChar;  
  int option_index = 0;
  static struct option long_options[] =
  {
    {"hostname", 1, 0, 'h'},		
    {"portnumber", 1, 0, 'p'},
    {0, 0, 0, 0}
  };

  while (1)							    /* Start parsing all known options */
  {
    optionChar = getopt_long_only (argc, argv, "h:p:",
				   long_options, &option_index);
    if (optionChar == EOF)					    /* Done with all known options */
    {
      break;
    }
    switch (optionChar)
    {
     case 'h':
      if (optarg) 
      {
	senderPort.hostName = (char *)malloc(sizeof(optarg) + 2);
	strcpy (senderPort.hostName, optarg);
      }
      break;
     case 'p':
      if (optarg) 
      {
	ReceiverPortNumber = atoi(optarg);
      }
      break;
     default:
      break;
    }
  }
  if (optind < argc)						    /* Check if a filename has been specified */
  {
    Browse(argv[optind], BrowseCheckOpen,
	   IS_EDITLIST, documentFirstLine, documentFileType);
    xv_set(dtr_editListPanelPopUp->editListPanelPopUp,
	   FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(dtr_editListPanelPopUp->editListPanelPopUp,
	   XV_SHOW, TRUE, NULL);
  }
}


void
  InitNetwork(argc, argv)
int  argc;
char **argv;
{
  static DispatchTable			DT = 
  {
    OpenDoc,
    GetDoc,
    GetSelection,
    SetSelection,
    PerformSelection,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    HaltSelection,
    PauseSelection,
    ResumeSelection,
    HideApplication,
    ShowApplication,
    GetAppIcon
    };
  
  senderPort.hostName = "localhost";
  senderPort.portNumber = AnyPort;
  sprintf(currentSoundFile,"Untitled");
  CheckOptions(argc, argv);
  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);
  if (sender == NULL)
  {
    AlertByNoticePrompt(dtr_mainWindow->mainWindow,
			"Error:  PortManager seems to be absent.  Please start PortManager again.");
    exit(0);
  }
  receiver = NewReceiver(sender, "DTR", ReceiverPortNumber);
  BuildDispatchTable(&DT);
  strcpy(oldFileName, "Untitled");
  SoundBufferReady = FALSE;
  (void) notify_enable_rpc_svc(TRUE);
}								    /* end function InitNetwork */



void
  OpenDoc(editListName)
char  **editListName;
{
  static  char     *lastEditListOpened = "Untitled";
  struct  stat     fileInfo;
  int              result;

  StopPlay();
/*
  SetWaveEditModeOff();
*/
  SoundBufferReady = FALSE;
  if (*editListName == NULL)					    /*  If an invalid editlist name is being requested, */
  {
    AlertByNoticePrompt(dtr_editListPanelPopUp->editListPanelPopUp,
			"Error:  The name of the edit-list is NULL");
    return;							    /*  ...return w/o doing anything.                   */
  }
  if (strcmp(*editListName, lastEditListOpened) == 0)
  {								    /*  If the last editlist opened is the same as...   */
    return;							    /*  ...the current one, return w/o doing anything.  */
  }
  lastEditListOpened = (char *)strdup(*editListName);		    /*  Duplicate the filename.                         */
  result = stat(*editListName, &fileInfo);			    /*  Check if the editlist file exists.              */
  if ((result == 0) && (!(fileInfo.st_mode & S_IFDIR)))
    ReadEditListFromFile(*editListName, NON_USER);
  else
  {
    AlertByNoticePrompt(dtr_editListPanelPopUp->editListPanelPopUp,
			"Error:  Edit-list not found/not valid.");
  }

/****************
  if (strcmp(fullFilename, oldFileName) == 0)
  {
    FileReady = TRUE;
    SameSoundFile = TRUE;
  }
  else
  {
    FileReady = FALSE;
    SameSoundFile = FALSE;
  }
  strcpy(oldFileName, fullFilename);
  sprintf(currentSoundFile,"%s",fullFilename);
  UpdateHeader(FALSE);

  SoundBufferReady = ReadSoundFile(TRUE);
  SameSoundFile = TRUE;
			
  WaveCanvasRightMarkerSet = FALSE;
  GlobalWaveCanvasRightMarkerSet = FALSE;
**************/
}								    /* end function OpenDoc */


void SetSelection(MAESelection* selection)
{
  int						entry;
  int           				gain;
  double					startingTimeInSec;
  double					endingTimeInSec;
  
  if (selection->start >= EditList.numItems)
  {
    AlertByNoticePrompt(dtr_editListPanelPopUp->editListPanelPopUp,
			"Error:  Illegal edit number.");
    return;
  }
  entry = selection->start;
  if (currentSelection != NO_CURRENT_EDIT)
  {
    xv_set (dtr_editListPanelPopUp->editListScrollList,
	    PANEL_LIST_SELECT, currentSelection, FALSE,
	    NULL);
  }
  currentSelection = entry;					    /*  Select the item in the Scroll list.             */
  xv_set(dtr_editListPanelPopUp->editListScrollList,		    
	 PANEL_LIST_SELECT, entry, TRUE,
	 NULL);
  SetCurrentSelection(entry, selection);
  return;
}								    /* end function SetSelection */



void PerformSelection(MAESelection* selection)
{
  StopPlay();
  DisableEditListPanel();
  Play(dtr_mainWindow);
  EnableEditListPanel();
}


char **
  GetDoc(unusedArg)
void *unusedArg;
{
  static  char   *returnValue;

  if (NullFileName(absoluteEditListName) ||
      strcmp(absoluteEditListName, "Untitled") == 0 ||
      strcmp(absoluteEditListName, "NoneSpecified") == 0)
  {
    AlertByNoticePrompt(dtr_editListPanelPopUp->editListPanelPopUp,
			"Warning:  The edit list is untitled.");
    returnValue = (char *)strdup("Untitled");
  }
  else
  {
    returnValue = absoluteEditListName;
  }
  return(&returnValue);
}								    /* end function GetDoc */



MAESelection* GetSelection(void* unusedArg)
{
  static MAESelection select;
  
  if (currentSelection == NO_CURRENT_EDIT)			    /*  Return select.duration = -1 if there is no...   */
  {								    /*  ...current MAESelection.                        */
    select.duration = -1;
    return(&select);
  }
  select.start = currentSelection;
  select.end = currentSelection;
  select.offset = 0;
  select.duration = irint(((EditList.endingMin[currentSelection] - EditList.startingMin[currentSelection]) * 60.0
			   + EditList.endingSec[currentSelection] - EditList.startingSec[currentSelection]) * 1000);
  if (strlen(EditList.label[currentSelection]) == 0)		    /*  Return the label of the edit to be the label...  */
  {								    /*  ...of the note on TimeLine.                      */
    strcpy(select.label, "No Label");
  }
  else
  {
    strcpy(select.label, EditList.label[currentSelection]);
  }
  return(&select);
}								    /* end function GetSelection */


void
  HaltSelection(MAESelection* selection)
{
  StopPlay();
  XFlush((Display *) xv_get(dtr_mainWindow->mainWindow,
			    XV_DISPLAY));
}


void
  PauseSelection()
{
  Pause();
}


void
  ResumeSelection()
{
  Pause();
}


void
  HideApplication()
{
  xv_set(dtr_mainWindow->mainWindow, FRAME_CLOSED, TRUE, NULL);
  XFlush((Display *) xv_get(dtr_mainWindow->mainWindow, 
			    XV_DISPLAY));
}


void
  ShowApplication()
{
  extern   dtr_globalWaveCanvasPopUp_objects	 *dtr_globalWaveCanvasPopUp;
  extern   dtr_infoPopUp_objects                 *dtr_infoPopUp;
  
  xv_set(dtr_mainWindow->mainWindow, FRAME_CLOSED, FALSE, NULL);
  if (xv_get(dtr_globalWaveCanvasPopUp->globalWaveCanvasPopUp, XV_SHOW) == (BOOL) TRUE)
  {
    xv_set(dtr_globalWaveCanvasPopUp->globalWaveCanvasPopUp, XV_SHOW, TRUE, NULL);
  }
  if (xv_get(dtr_editListPanelPopUp->editListPanelPopUp, XV_SHOW) == (BOOL) TRUE)
  {
    xv_set(dtr_editListPanelPopUp->editListPanelPopUp, XV_SHOW, TRUE, NULL);
  }
  if (xv_get(dtr_infoPopUp->infoPopUp, XV_SHOW) == (BOOL) TRUE)
  {
    xv_set(dtr_infoPopUp->infoPopUp, XV_SHOW, TRUE, NULL);
  }
  XRaiseWindow((Display *)xv_get(dtr_mainWindow->mainWindow, XV_DISPLAY),
	       (Window) xv_get(dtr_mainWindow->mainWindow, XV_XID));
  XFlush((Display *) xv_get(dtr_mainWindow->mainWindow, 
			    XV_DISPLAY));
}								    /* end function ShowApplication */


IconData *
  GetAppIcon()
{
  static IconData returnVal;
  static unsigned short mainWindow_bits[] = {
#include "icons/dtr.icon"
        };

  returnVal.iconData = (char *)malloc(sizeof(mainWindow_bits));
  bcopy(mainWindow_bits, returnVal.iconData, sizeof(mainWindow_bits));

  if (returnVal.iconData)
    returnVal.dataLength = sizeof(mainWindow_bits);

  return(&returnVal);
}






