/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * solid.c - create a solid image.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Thu Jan 16 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

create_solid_image(image, xsize, ysize, r, g, b)
bitmap_hdr *image;
int xsize, ysize;
byte r, g, b;
{
  int totalsize = xsize * ysize;

  image->magic = LUGUSED;
  image->xsize = xsize;
  image->ysize = ysize;
  image->depth = 24;
  image->colors = ( 1 << image->depth );
  image->r= (byte *) Malloc( totalsize );
  image->g= (byte *) Malloc( totalsize );
  image->b= (byte *) Malloc( totalsize );
  if ( r )
    memset( image->r, r, totalsize );
  if ( g )
      memset( image->g, g, totalsize );
  if ( b )
      memset( image->b, b, totalsize );
}
