#include <lug.h>
#include <lugfnts.h>

main(argc, argv)
int argc;
char **argv;
{
  bitmap_hdr in, out;

  if ( argc < 3 ) {
    fprintf( stderr, "Usage: %s <input> <output>\n", argv[0] );
    exit( 1 );
  }

  read_alias_file( argv[1], &in );
  create_solid_image( &out, in.xsize, in.ysize, 0, 0, 0 );
  siluet( &in, &out );
  write_alias_file( argv[2], &out );
}

siluet( base, super )
bitmap_hdr *base;
bitmap_hdr *super;
{
  register int i, j;
  register byte *r1, *g1, *b1;
  register byte *r2, *g2, *b2;

  /* Set pointers */
  r1= base->r , g1= base->g , b1= base->b;
  r2= super->r, g2= super->g, b2= super->b;

  for ( i = 0; i < base->ysize; i++ ) {
    for ( j = 0; j < base->xsize; j++ ) {
      if ( (*r1++ + *g1++ + *b1++) < 20 ) {
	r2++, g2++, b2++;
      }else {
	*r2++ = 255;
	*g2++ = 255;
	*b2++ = 255;
      }
    }
  }
}
