 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfdmax.h
 >>>>            Author: Jean-Pierre Guerin, Jean-Francois Larue, Marc Viala
 >>>> Date Last Updated: Thu Mar 26 10:39:47 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vfdmax_h_
#define _vfdmax_h_

#include "vinclude.h"


/* -include_includes */
/* for direct H. output and inverse H. input az image: */
#define IMA_TYP          unsigned long
#define VVF_HOUGH_TYP    VFF_TYP_4_BYTE

#define WMAX 15
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vfdmax Argument Structure
*
****************************************************************/

typedef struct _vfdmax  {

/*
 *  input HOUGH domain image (Required infile)
 */
char	*i_file;	/* input HOUGH domain image FILENAME */
int	 i_flag;	/* input HOUGH domain image FLAG */

/*
 *  image of found maxima (Optional outfile)
 */
char	*o_file;	/* image of found maxima FILENAME */
int	 o_flag;	/* image of found maxima FLAG */

/*
 *  Output Hough Image with Moebius sides (Optional outfile)
 */
char	*o1_file;	/* Output Hough Image with Moebius sides FILENAME */
int	 o1_flag;	/* Output Hough Image with Moebius sides FLAG */

/*
 *  list of maxima output file (Optional outfile)
 */
char	*om_file;	/* list of maxima output file FILENAME */
int	 om_flag;	/* list of maxima output file FLAG */

/*
 *  the Value of Threshold (Optional integer)
 */
int	 t_int; 	/* the Value of Threshold INT */
int	 t_flag;	/* the Value of Threshold FLAG */

/*
 *  the value of square Window Size (odd) (Optional integer)
 */
int	 w_int; 	/* the value of square Window Size (odd) INT */
int	 w_flag;	/* the value of square Window Size (odd) FLAG */

/*
 *  selects 1 for printing (Optional logical)
 */
int	 p_logic;	/* selects 1 for printing LOGIC */
int	 p_flag;  	/* selects 1 for printing FLAG */

}  vfdmax_struct;

vfdmax_struct *vfdmax;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vfdmax->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vfdmax: Image could not be read...\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        (void) proper_num_bands(program,image,1,TRUE)

#define WRITEOUTPUT(image) \
    writeimage(vfdmax->o_file, image)

/* -include_macros_end */

#endif
